/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.docx;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gendoc.documents.AbstractTableService;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.services.exception.InvalidContentException;
import org.eclipse.gendoc.table.Cell;
import org.eclipse.gendoc.table.Row;
import org.eclipse.gendoc.table.Table;
import org.eclipse.gendoc.tags.ITag;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOCXTableService
extends AbstractTableService {
    public String manageTable(ITag tag, IDocumentService documentService, StringBuffer returnValue, Object tableModel, Node tableNode) throws InvalidContentException {
        Node mainTable = tableNode.getFirstChild();
        if (documentService.isTable(mainTable.getNodeName()) && tableModel instanceof Table) {
            String wdth = this.getChildNode("w:gridCol", this.getChildNode("w:tblGrid", mainTable)).getAttributes().getNamedItem("w:w").getNodeValue();
            Node rowNode = this.getChildNode(documentService.getRowLabel(), mainTable);
            String rowLabel = documentService.getRowLabel();
            Pattern rowPattern = Pattern.compile("<" + rowLabel + "[^<>]*>.*</" + rowLabel + ">");
            Matcher rowm = rowPattern.matcher(returnValue);
            int index_row_start = 0;
            int index_row_end = 0;
            if (rowm.find()) {
                index_row_start = rowm.start();
                index_row_end = returnValue.lastIndexOf("</" + rowLabel + ">");
                String row = returnValue.substring(index_row_start, index_row_end + rowLabel.length() + 3);
                String colLabel = documentService.getCellLabel();
                int index_col_start = row.lastIndexOf("<" + colLabel + ">");
                int index_col_end = row.lastIndexOf("</" + colLabel + ">");
                Node colNode = this.getChildNode(documentService.getCellLabel(), rowNode);
                int nbCol = ((Table)tableModel).getColCount();
                int colWidth = Math.round(Integer.parseInt(wdth) / nbCol);
                this.getChildNode("w:tcW", this.getChildNode("w:tcPr", colNode)).getAttributes().getNamedItem("w:w").setNodeValue(String.valueOf(colWidth));
                StringBuffer colNodetxt = new StringBuffer(documentService.asText(colNode));
                String txtLabel = "w:p";
                String txtstyleLabel = "w:rPr";
                Pattern txtPattern = Pattern.compile("<" + txtLabel + "[^<>]*>.*</" + txtLabel + ">");
                Pattern txtstylePattern = Pattern.compile("<" + txtstyleLabel + "[^<>]*>.*</" + txtstyleLabel + ">");
                Matcher txtm = txtPattern.matcher(colNodetxt);
                Matcher txtstylem = txtstylePattern.matcher(colNodetxt);
                if (txtm.find()) {
                    String style = "";
                    if (txtstylem.find()) {
                        style = colNodetxt.substring(txtstylem.start(), txtstylem.end() + txtstyleLabel.length() + 3);
                    }
                    return this.generateTable(returnValue, tableModel, rowLabel, index_row_start, index_row_end, row, colLabel, index_col_start, index_col_end, colNodetxt, txtm, style, txtLabel);
                }
            }
        }
        return null;
    }

    private Node getChildNode(String label, Node parentnode) {
        NodeList rowChildNodes = parentnode.getChildNodes();
        int i = 0;
        while (i < rowChildNodes.getLength()) {
            Node current = rowChildNodes.item(i);
            if (current.getNodeName() == label) {
                return current;
            }
            ++i;
        }
        return null;
    }

    private String generateTable(StringBuffer returnValue, Object tableModel, String rowLabel, int index_row_start, int index_row_end, String row, String colLabel, int index_col_start, int index_col_end, StringBuffer colNodetxt, Matcher txtm, String style, String txtLabel) {
        String rows = "";
        String cells = "";
        StringBuffer newRow = new StringBuffer(row);
        cells = this.generateCells((EList<Cell>)((Table)tableModel).getTableheader().getCells(), colNodetxt, txtm, style, txtLabel);
        newRow.replace(index_col_start, index_col_end + colLabel.length() + 3, cells);
        rows = String.valueOf(rows) + newRow.toString();
        for (Row r : ((Table)tableModel).getRows()) {
            newRow = new StringBuffer(row);
            cells = this.generateCells((EList<Cell>)r.getCells(), colNodetxt, txtm, style, txtLabel);
            newRow.replace(index_col_start, index_col_end + colLabel.length() + 3, cells);
            rows = String.valueOf(rows) + newRow.toString();
        }
        return returnValue.replace(index_row_start, index_row_end + rowLabel.length() + 3, rows).toString();
    }

    private String generateCells(EList<Cell> modelCells, StringBuffer colNodetxt, Matcher txtm, String style, String txtLabel) {
        String cols = "";
        for (Cell cell : modelCells) {
            int txtindex = txtm.end() - txtLabel.length() - 3;
            StringBuffer newCol = new StringBuffer(colNodetxt.toString());
            newCol.insert(txtindex, "<w:r>" + style + "<w:t>" + cell.getLabel() + "</w:t></w:r>");
            cols = String.valueOf(cols) + newCol.toString();
        }
        return cols;
    }
}

