/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.impl;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gendoc.tags.TagsExtensionPoint;
import org.eclipse.gendoc.tags.impl.AbstractContainerExtension;
import org.eclipse.gendoc.tags.impl.AbstractExtension;
import org.eclipse.gendoc.tags.impl.TagExtensionService;

public class CategoryExtension
extends AbstractContainerExtension {
    private final String name;

    public static CategoryExtension load(TagExtensionService tagExtensionService, IConfigurationElement configElement) {
        if (!configElement.getName().equals(TagsExtensionPoint.CATEGORY)) {
            return null;
        }
        try {
            String name = AbstractExtension.parseStringAttribute(configElement, "name", false);
            CategoryExtension categoryExtension = tagExtensionService.getCategoryExtension(name);
            if (categoryExtension != null) {
                categoryExtension.loadChildren(configElement);
            } else {
                categoryExtension = new CategoryExtension(tagExtensionService, configElement);
                if (categoryExtension != null) {
                    tagExtensionService.getCategoryExtensions().add(categoryExtension);
                }
            }
            return categoryExtension;
        }
        catch (Exception e) {
            String message = "Failed to load " + TagsExtensionPoint.TAG + " in " + configElement.getDeclaringExtension().getNamespaceIdentifier();
            AbstractExtension.log(message, e);
            return null;
        }
    }

    protected CategoryExtension(TagExtensionService tagExtensionService, IConfigurationElement configElement) {
        super(tagExtensionService, configElement);
        this.name = CategoryExtension.parseStringAttribute(configElement, TagsExtensionPoint.TAG_NAME, true);
    }

    public String getName() {
        return this.name;
    }
}

