/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.bundle.acceleo.html.files;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gendoc.bundle.acceleo.html.files.HtmlStripTagVisitor;
import org.eclipse.gendoc.bundle.acceleo.html.files.IHtmlVisitor;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class HtmlToTextVisitor
extends HtmlStripTagVisitor
implements IHtmlVisitor {
    private int listIndent = 0;
    private boolean newLine = false;
    private boolean item = false;
    private List<Integer> lists = new ArrayList<Integer>();

    @Override
    public boolean visitElement(Element node) {
        boolean res = super.visitElement(node);
        String tag = node.getTagName();
        if (tag.equals("ol")) {
            ++this.listIndent;
            this.lists.add(0);
        } else if (tag.equals("ul")) {
            ++this.listIndent;
            this.lists.add(-1);
        } else if (tag.equals("li")) {
            int l;
            this.item = true;
            if (this.lists.size() == 0) {
                this.lists.add(0);
            }
            if ((l = this.lists.get(this.lists.size() - 1).intValue()) >= 0) {
                this.lists.set(this.lists.size() - 1, l + 1);
            }
        }
        return res;
    }

    @Override
    public void visitElementAfter(Element node) {
        String tag = node.getTagName();
        if (tag.equals("ol")) {
            --this.listIndent;
            this.lists.remove(this.lists.size() - 1);
        } else if (tag.equals("ul")) {
            --this.listIndent;
            this.lists.remove(this.lists.size() - 1);
        }
        super.visitElementAfter(node);
    }

    @Override
    public void visitText(Text node) {
        if (this.newLine) {
            int i = 0;
            while (i < this.listIndent) {
                this.buf.append("\t");
                ++i;
            }
        }
        this.newLine = false;
        if (this.item && this.lists.size() > 0) {
            int l = this.lists.get(this.lists.size() - 1);
            if (l < 0) {
                this.buf.append("- ");
            } else if (l >= 0) {
                this.buf.append(l).append(". ");
            }
        }
        this.item = false;
        super.visitText(node);
    }

    @Override
    protected void newLine() {
        super.newLine();
        this.newLine = true;
    }
}

