/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.process.buffers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.InvalidContentException;
import org.eclipse.gendoc.tags.handlers.process.buffers.ITagAnalyserBuffer;
import org.w3c.dom.Node;

public class DeferredStringTagAnalyserBuffer
extends AbstractService
implements ITagAnalyserBuffer {
    List<BufferStruct> listOfBuffers = new ArrayList<BufferStruct>();

    @Override
    public void bufferize(Document document, Node currentNode, StringBuffer finalText, List<Node> nodesList) {
        BufferStruct buf = new BufferStruct(document, currentNode, finalText, nodesList);
        this.listOfBuffers.add(buf);
    }

    @Override
    public void flush() {
        Iterator<BufferStruct> i = this.listOfBuffers.iterator();
        while (i.hasNext()) {
            BufferStruct b = i.next();
            IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
            try {
                Node sibling = documentService.injectNode(b.currentNode, b.finalText.toString());
                for (Node node : b.nodesList) {
                    node.getParentNode().removeChild(node);
                }
                b.document.getXMLParser().setCurrentNode(sibling);
            }
            catch (InvalidContentException e) {
                e.printStackTrace();
            }
            i.remove();
        }
    }

    private static class BufferStruct {
        private final Document document;
        private final Node currentNode;
        private final StringBuffer finalText;
        private final List<Node> nodesList;

        public BufferStruct(Document document, Node currentNode, StringBuffer finalText, List<Node> nodesList) {
            this.document = document;
            this.currentNode = currentNode;
            this.finalText = finalText;
            this.nodesList = nodesList;
        }
    }
}

