/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.utils;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.eclipse.glsp.server.launch.DefaultCLIParser;

public final class LaunchUtil {
    private static Logger LOGGER = LogManager.getLogger(LaunchUtil.class);

    private LaunchUtil() {
    }

    public static boolean isValidPort(Integer port) {
        return port >= 0 && port <= 65535;
    }

    public static void configure(DefaultCLIParser cli) throws ParseException {
        if (cli.isHelp()) {
            cli.printHelp();
            System.exit(0);
        }
        LaunchUtil.configureLogger(cli);
        if (cli.hasOption("logDir") && !cli.isFileLog()) {
            LOGGER.warn(String.format("File logging is disabled. The option '--%s' will be ignored.", "logDir"));
        }
    }

    public static void configureLogger(DefaultCLIParser cli) throws ParseException {
        if (cli.isFileLog()) {
            LaunchUtil.configureLogger(cli.isConsoleLog(), cli.parseLogDir(), cli.parseLogLevel());
        } else {
            LaunchUtil.configureLogger(cli.isConsoleLog(), cli.parseLogLevel());
        }
    }

    public static void configureLogger(boolean logToConsole, Level logLevel) {
        LaunchUtil.configureLogger(logToConsole, null, logLevel);
    }

    protected static String getLoggingPatternLayout() {
        return "%d{DEFAULT_NANOS} [%t] %-5level %logger{1} - %msg%n";
    }

    protected static String getLogFileName() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy_HH:mm:ss");
        return "glsp-server_" + formatter.format(new Date()) + ".log";
    }

    protected static String getRollingFileSize() {
        return "5MB";
    }

    public static void configureLogger(boolean logToConsole, String logDir, Level logLevel) {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        RootLoggerComponentBuilder rootLogger = builder.newRootLogger(logLevel);
        LayoutComponentBuilder patternLayout = (LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", LaunchUtil.getLoggingPatternLayout());
        if (logToConsole) {
            AppenderComponentBuilder consoleAppender = ((AppenderComponentBuilder)builder.newAppender("ConsoleLogger", "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT)).add(patternLayout);
            builder.add(consoleAppender);
            rootLogger.add(builder.newAppenderRef("ConsoleLogger"));
        }
        if (logDir != null && !logDir.isEmpty()) {
            String logFilePath = new File(logDir, LaunchUtil.getLogFileName()).getAbsolutePath();
            ComponentBuilder triggeringPolicy = builder.newComponent("Policies").addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", LaunchUtil.getRollingFileSize()));
            AppenderComponentBuilder fileAppender = ((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("RollingFileLogger", "RollingFile").addAttribute("fileName", logFilePath)).addAttribute("filePattern", String.valueOf(logFilePath) + "-%i.log.gz")).addComponent(triggeringPolicy)).add(patternLayout);
            builder.add(fileAppender);
            rootLogger.add(builder.newAppenderRef("RollingFileLogger"));
        }
        builder.add(rootLogger);
        Configurator.reconfigure((Configuration)((Configuration)builder.build()));
    }

    public static <T extends Appender> List<T> getAppenders(LoggerContext context, Class<T> clazz) {
        ArrayList<Appender> result = new ArrayList<Appender>();
        Map allAppenders = context.getRootLogger().getAppenders();
        for (Appender appender : allAppenders.values()) {
            if (!clazz.isInstance(appender)) continue;
            result.add((Appender)clazz.cast(appender));
        }
        return result;
    }

    public static void printHelp(String processName, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String cmdLineSyntax = "java -jar " + processName;
        formatter.printHelp(90, cmdLineSyntax, "\noptions:", options, "", true);
    }

    public static final class DefaultOptions {
        public static final int SERVER_PORT = 0;
        public static final String HOST_NAME = "127.0.0.1";
        public static final Level LOG_LEVEL = Level.INFO;
        public static final String LOG_DIR = new File("./logs/").getAbsolutePath();
        public static final boolean CONSOLE_LOG_ENABLED = true;
        public static final boolean FILE_LOG_ENABLED = false;
    }
}

