/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries.operations.scopes.annotations;

import java.util.function.Supplier;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNodeIndex;
import org.eclipse.hawk.timeaware.queries.TimeAwareEOLQueryEngine;
import org.eclipse.hawk.timeaware.queries.operations.scopes.StartingTimeAwareNodeWrapper;
import org.eclipse.hawk.timeaware.queries.operations.scopes.annotations.AbstractAnnotatedOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AfterAnnotatedOperation
extends AbstractAnnotatedOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(AfterAnnotatedOperation.class);

    public AfterAnnotatedOperation(Supplier<TimeAwareEOLQueryEngine> containerModelSupplier) {
        super(containerModelSupplier);
    }

    @Override
    protected ITimeAwareGraphNode useAnnotations(ITimeAwareGraphNodeIndex index, ITimeAwareGraphNode taNode, String derivedAttrName) {
        Long firstVersion = index.getEarliestVersionSince(taNode, derivedAttrName, (Object)true);
        if (firstVersion == null) {
            return null;
        }
        ITimeAwareGraphNode node = taNode.travelInTime(firstVersion.longValue());
        try {
            ITimeAwareGraphNode next = node.getNext();
            if (next != null) {
                return new StartingTimeAwareNodeWrapper(next);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not fetch next version", (Throwable)e);
        }
        return null;
    }
}

