/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.graph.TypeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slot {
    public static final String ATTR_TYPE_TIMEANNOTATION = "TimelineAnnotation";
    private static final Logger LOGGER = LoggerFactory.getLogger(Slot.class);
    private final TypeNode typeNode;
    private final String propertyName;
    private final String propertyType;
    private final PropertyCategory propertyCategory;
    private final boolean isMany;
    private final boolean isOrdered;
    private final boolean isUnique;
    private final boolean isIndexed;
    private final String derivationLanguage;
    private final String derivationLogic;

    private static String boolString(boolean b) {
        return b ? "t" : "f";
    }

    private static boolean stringBool(String s) {
        return "t".equals(s);
    }

    public Slot(TypeNode typeNode, String propertyName, String[] propertyMetadata) {
        this.typeNode = typeNode;
        this.propertyName = propertyName;
        this.propertyCategory = PropertyCategory.fromLetter(propertyMetadata[0]);
        this.isMany = Slot.stringBool(propertyMetadata[1]);
        this.isOrdered = Slot.stringBool(propertyMetadata[2]);
        this.isUnique = Slot.stringBool(propertyMetadata[3]);
        this.propertyType = propertyMetadata[4];
        boolean bl = this.isIndexed = this.propertyCategory == PropertyCategory.ATTRIBUTE && Slot.stringBool(propertyMetadata[5]);
        if (this.propertyCategory == PropertyCategory.DERIVED) {
            this.derivationLanguage = propertyMetadata[5];
            this.derivationLogic = propertyMetadata[6];
        } else {
            this.derivationLanguage = null;
            this.derivationLogic = null;
        }
    }

    public Slot(TypeNode typeNode, String propertyName) {
        this(typeNode, propertyName, (String[])typeNode.getNode().getProperty(propertyName));
    }

    protected Collection<Object> getCollection() {
        if (this.isOrdered && this.isUnique) {
            return new LinkedHashSet<Object>();
        }
        if (this.isOrdered) {
            return new ArrayList<Object>();
        }
        if (this.isUnique) {
            return new HashSet<Object>();
        }
        return new ArrayList<Object>();
    }

    public TypeNode getTypeNode() {
        return this.typeNode;
    }

    public String getName() {
        return this.propertyName;
    }

    public boolean isAttribute() {
        return this.propertyCategory == PropertyCategory.ATTRIBUTE;
    }

    public boolean isReference() {
        return this.propertyCategory == PropertyCategory.REFERENCE;
    }

    public boolean isMixed() {
        return this.propertyCategory == PropertyCategory.MIXED;
    }

    public boolean isDerived() {
        return this.propertyCategory == PropertyCategory.DERIVED;
    }

    public boolean isMany() {
        return this.isMany;
    }

    public boolean isOrdered() {
        return this.isOrdered;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public boolean isIndexed() {
        return this.isIndexed;
    }

    public String getType() {
        return this.propertyType;
    }

    public String getNodeIndexName() {
        if (!this.isDerived() && !this.isIndexed()) {
            return null;
        }
        String result = null;
        IGraphDatabase graph = this.typeNode.getNode().getGraph();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (IGraphTransaction ignored = graph.beginTransaction();){
                String indexname = String.format("%s##%s##%s", this.typeNode.getMetamodelURI(), this.typeNode.getTypeName(), this.propertyName);
                if (graph.nodeIndexExists(indexname)) {
                    result = indexname;
                }
                ignored.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error while locating the index for this derived property", (Throwable)e);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.propertyName == null ? 0 : this.propertyName.hashCode());
        result = 31 * result + (this.typeNode == null ? 0 : this.typeNode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Slot other = (Slot)obj;
        if (this.propertyName == null ? other.propertyName != null : !this.propertyName.equals(other.propertyName)) {
            return false;
        }
        return !(this.typeNode == null ? other.typeNode != null : !this.typeNode.equals(other.typeNode));
    }

    public String getDerivationLanguage() {
        return this.derivationLanguage;
    }

    public String getDerivationLogic() {
        return this.derivationLogic;
    }

    public String toString() {
        return "Slot [typeNode=" + this.typeNode + ", propertyName=" + this.propertyName + ", propertyType=" + this.propertyType + ", propertyCategory=" + (Object)((Object)this.propertyCategory) + ", isMany=" + this.isMany + ", isOrdered=" + this.isOrdered + ", isUnique=" + this.isUnique + ", isIndexed=" + this.isIndexed + ", derivationLanguage=" + this.derivationLanguage + ", derivationLogic=" + this.derivationLogic + "]";
    }

    public static class MetadataBuilder {
        private String propertyType;
        private String derivationLanguage;
        private String derivationLogic;
        private PropertyCategory pCategory = PropertyCategory.ATTRIBUTE;
        private boolean isMany;
        private boolean isOrdered;
        private boolean isUnique;
        private boolean isIndexed;

        public MetadataBuilder attribute() {
            this.pCategory = PropertyCategory.ATTRIBUTE;
            return this;
        }

        public MetadataBuilder reference() {
            this.pCategory = PropertyCategory.REFERENCE;
            return this;
        }

        public MetadataBuilder mixed() {
            this.pCategory = PropertyCategory.MIXED;
            return this;
        }

        public MetadataBuilder derived() {
            this.pCategory = PropertyCategory.DERIVED;
            return this;
        }

        public MetadataBuilder type(String s) {
            this.propertyType = s;
            return this;
        }

        public MetadataBuilder derivationLanguage(String s) {
            this.derivationLanguage = s;
            return this;
        }

        public MetadataBuilder derivationLogic(String s) {
            this.derivationLogic = s;
            return this;
        }

        public MetadataBuilder many(boolean b) {
            this.isMany = b;
            return this;
        }

        public MetadataBuilder ordered(boolean b) {
            this.isOrdered = b;
            return this;
        }

        public MetadataBuilder unique(boolean b) {
            this.isUnique = b;
            return this;
        }

        public MetadataBuilder indexed(boolean b) {
            this.isIndexed = b;
            return this;
        }

        public String[] build() {
            String[] metadata = this.pCategory == PropertyCategory.DERIVED ? new String[7] : new String[6];
            metadata[0] = this.pCategory.getLetter();
            metadata[1] = Slot.boolString(this.isMany);
            metadata[2] = Slot.boolString(this.isOrdered);
            metadata[3] = Slot.boolString(this.isUnique);
            metadata[4] = this.propertyType;
            if (this.pCategory == PropertyCategory.DERIVED) {
                metadata[5] = this.derivationLanguage;
                metadata[6] = this.derivationLogic;
            } else {
                metadata[5] = Slot.boolString(this.pCategory == PropertyCategory.ATTRIBUTE && this.isIndexed);
            }
            return metadata;
        }
    }

    public static enum PropertyCategory {
        ATTRIBUTE{

            @Override
            public String getLetter() {
                return "a";
            }
        }
        ,
        REFERENCE{

            @Override
            public String getLetter() {
                return "r";
            }
        }
        ,
        MIXED{

            @Override
            public String getLetter() {
                return "m";
            }
        }
        ,
        DERIVED{

            @Override
            public String getLetter() {
                return "d";
            }
        };


        public abstract String getLetter();

        public static PropertyCategory fromLetter(String letter) {
            PropertyCategory[] propertyCategoryArray = PropertyCategory.values();
            int n = propertyCategoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyCategory pc = propertyCategoryArray[n2];
                if (pc.getLetter().equals(letter)) {
                    return pc;
                }
                ++n2;
            }
            throw new NoSuchElementException(letter);
        }
    }
}

