/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.util;

import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class ConstraintViolationAssertTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)ConstraintViolationAssertTest.webArchiveBuilder().withTestClass(ConstraintViolationAssertTest.class)).withClass(Foo.class)).build();
    }

    @Test
    public void testConstraintTypeCorrect() {
        Set violations = TestUtil.getValidatorUnderTest().validate((Object)new Foo(null), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testConstraintTypeIncorrect() {
        Set violations = TestUtil.getValidatorUnderTest().validate((Object)new Foo(null), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class));
    }

    @Test
    public void testMessageCorrect() {
        Set violations = TestUtil.getValidatorUnderTest().validate((Object)new Foo(null), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withMessage("message"));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testMessageIncorrect() {
        Set violations = TestUtil.getValidatorUnderTest().validate((Object)new Foo(null), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withMessage("wrong message"));
    }

    @Test
    public void testRootBeanClassCorrect() {
        Set violations = TestUtil.getValidatorUnderTest().validate((Object)new Foo(null), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withRootBeanClass(Foo.class));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testRootBeanClassIncorrect() {
        Set violations = TestUtil.getValidatorUnderTest().validate((Object)new Foo(null), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withRootBeanClass(ConstraintViolationAssertTest.class));
    }

    @Test
    public void testInvalidValueCorrect() {
        Set violations = TestUtil.getValidatorUnderTest().validate((Object)new Foo(null), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withInvalidValue(null));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testInvalidValueIncorrect() {
        Set violations = TestUtil.getValidatorUnderTest().validate((Object)new Foo(null), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withInvalidValue("not null"));
    }

    @Test
    public void testPropertyCorrect() {
        Set violations = TestUtil.getValidatorUnderTest().validate((Object)new Foo(null), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("string"));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPropertyIncorrect() {
        Set violations = TestUtil.getValidatorUnderTest().validate((Object)new Foo(null), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("wrongPropertyName"));
    }

    @Test
    public void testPropertyPathCorrect() throws Exception {
        Set violations = TestUtil.getValidatorUnderTest().forExecutables().validateReturnValue((Object)new Foo(null), Foo.class.getDeclaredMethod("bar", new Class[0]), null, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("bar").returnValue()));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPropertyPathIncorrect() throws Exception {
        Set violations = TestUtil.getValidatorUnderTest().forExecutables().validateReturnValue((Object)new Foo(null), Foo.class.getDeclaredMethod("bar", new Class[0]), null, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("bar").property("nonExistingProperty").returnValue()));
    }

    @Test
    public void testLeafBeanCorrect() {
        Foo foo = new Foo(null);
        Set violations = TestUtil.getValidatorUnderTest().validate((Object)foo, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withLeafBean(foo));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testLeafBeanIncorrect() {
        Set violations = TestUtil.getValidatorUnderTest().validate((Object)new Foo(null), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withLeafBean("not the leaf bean"));
    }

    private static class Foo {
        @NotNull(message="message")
        private final @NotNull(message="message") String string;

        public Foo(String string) {
            this.string = string;
        }

        @NotNull
        public String bar() {
            return null;
        }
    }
}

