/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

class DefaultPublisher<T>
implements Flow.Publisher<T> {
    private final Supplier<Optional<T>> supplier;
    private final Executor executor;

    DefaultPublisher(Supplier<Optional<T>> supplier, Executor executor) {
        this.supplier = supplier;
        this.executor = executor;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        try {
            subscriber.onSubscribe(new Subscription(subscriber));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            subscriber.onError(new IllegalStateException(rejectedExecutionException));
        }
    }

    private class Subscription
    implements Flow.Subscription {
        private final Flow.Subscriber<? super T> subscriber;
        private final AtomicBoolean done = new AtomicBoolean();
        private final AtomicLong demand = new AtomicLong();
        private final Lock consumerLock = new ReentrantLock();
        private final Condition consumerAlarm = this.consumerLock.newCondition();

        Subscription(Flow.Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
            DefaultPublisher.this.executor.execute(() -> {
                block12: {
                    try {
                        while (!this.done.get()) {
                            this.consumerLock.lock();
                            try {
                                while (!this.done.get() && this.demand.get() == 0L) {
                                    this.consumerAlarm.await();
                                }
                            }
                            finally {
                                this.consumerLock.unlock();
                            }
                            long l = this.demand.getAndSet(0L);
                            for (long i = 0L; i < l && !this.done.get(); ++i) {
                                try {
                                    Optional optional = (Optional)Objects.requireNonNull(DefaultPublisher.this.supplier.get());
                                    if (optional.isPresent()) {
                                        subscriber.onNext((Object)optional.get());
                                        continue;
                                    }
                                    if (!this.done.compareAndSet(false, true)) continue;
                                    subscriber.onComplete();
                                    continue;
                                }
                                catch (RuntimeException runtimeException) {
                                    if (!this.done.compareAndSet(false, true)) continue;
                                    subscriber.onError(runtimeException);
                                }
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        if (!this.done.compareAndSet(false, true)) break block12;
                        subscriber.onError(interruptedException);
                    }
                }
            });
        }

        @Override
        public void request(long l) {
            if (!this.done.get() && l > 0L) {
                this.demand.updateAndGet(l2 -> l2 + l > 0L ? l2 + l : Long.MAX_VALUE);
                this.wakeConsumer();
            } else if (this.done.compareAndSet(false, true)) {
                this.subscriber.onError(new IllegalArgumentException("request(" + l + ")"));
            }
        }

        @Override
        public void cancel() {
            this.done.set(true);
            this.wakeConsumer();
        }

        private void wakeConsumer() {
            this.consumerLock.lock();
            try {
                this.consumerAlarm.signal();
            }
            finally {
                this.consumerLock.unlock();
            }
        }
    }
}

