/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.common.util;

import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.TestNum;
import jakarta.el.ELProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Validator {
    private static final System.Logger logger = System.getLogger(Validator.class.getName());
    private static Validator instance = null;

    protected Validator() {
    }

    private Validator getInstance() {
        if (instance == null) {
            instance = new Validator();
        }
        return instance;
    }

    public static void testBigDecimal(BigDecimal testVal, Object expectedVal, String operator) throws Exception {
        boolean pass = false;
        for (int i = 0; TestNum.getNumberList().size() > i; ++i) {
            logger.log(System.Logger.Level.INFO, "*** Start \"BigDecimal\" Test Sequence ***");
            Object testNum = TestNum.getNumberList().get(i);
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            try {
                String expr = ExprEval.buildElExpr(true, operator);
                logger.log(System.Logger.Level.INFO, "expression to be evaluated is " + expr);
                logger.log(System.Logger.Level.INFO, "types are BigDecimal and " + testNum.getClass().getName());
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                logger.log(System.Logger.Level.INFO, "result is " + result.toString());
                if ("+=".equals(operator)) {
                    pass = Validator.runConcatenationTest(testVal, result, testNum);
                } else if ("%".equals(operator)) {
                    returnType = Double.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, ((BigDecimal)expectedVal).doubleValue());
                } else {
                    returnType = BigDecimal.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((BigDecimal)result, (BigDecimal)expectedVal, 5);
                }
            }
            catch (RuntimeException re) {
                ELTestUtil.printStackTrace(re);
                throw new Exception(re);
            }
            catch (Exception e) {
                ELTestUtil.printStackTrace(e);
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                logger.log(System.Logger.Level.INFO, "*** End \"BigDecimal\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testFloat(Float testVal, Object expectedVal, String operator) throws Exception {
        boolean pass = false;
        for (int i = 0; TestNum.getNumberList().size() > i; ++i) {
            logger.log(System.Logger.Level.INFO, "*** Start \"Float\" Test Sequence ***");
            Object testNum = TestNum.getNumberList().get(i);
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            if (testNum instanceof BigDecimal) {
                logger.log(System.Logger.Level.INFO, "Skip " + testNum.getClass().getSimpleName() + " for Float tests we already tested for this in the BigDecimal tests.");
                continue;
            }
            try {
                String expr = ExprEval.buildElExpr(true, operator);
                logger.log(System.Logger.Level.INFO, "expression to be evaluated is " + expr);
                logger.log(System.Logger.Level.INFO, "types are Float and " + testNum.getClass().getName());
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                logger.log(System.Logger.Level.INFO, "result is " + result.toString());
                if ("+=".equals(operator)) {
                    pass = Validator.runConcatenationTest(testVal, result, testNum);
                } else if ("%".equals(operator)) {
                    returnType = Double.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, ((Float)expectedVal).doubleValue());
                } else if (testNum instanceof BigInteger) {
                    returnType = BigDecimal.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue(Float.valueOf(((BigDecimal)result).floatValue()), (Float)expectedVal, 3);
                } else {
                    returnType = Double.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, (Float)expectedVal, 3);
                }
            }
            catch (RuntimeException re) {
                ELTestUtil.printStackTrace(re);
                throw new Exception(re);
            }
            catch (Exception e) {
                ELTestUtil.printStackTrace(e);
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                logger.log(System.Logger.Level.INFO, "*** End \"Float\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testDouble(Double testVal, Object expectedVal, String operator) throws Exception {
        boolean pass = false;
        for (int i = 0; TestNum.getNumberList().size() > i; ++i) {
            logger.log(System.Logger.Level.INFO, "*** Start \"Double\"Test Sequence ***");
            Object testNum = TestNum.getNumberList().get(i);
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            if (testNum instanceof BigDecimal || testNum instanceof Float) {
                String skipType = testNum.getClass().getSimpleName();
                logger.log(System.Logger.Level.INFO, "Skip " + skipType + " Data type already tested for this in the " + skipType + " tests.");
                continue;
            }
            try {
                String expr = ExprEval.buildElExpr(true, operator);
                logger.log(System.Logger.Level.INFO, "expression to be evaluated is " + expr);
                logger.log(System.Logger.Level.INFO, "types are Double and " + testNum.getClass().getName());
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                logger.log(System.Logger.Level.INFO, "result is " + result.toString());
                if ("+=".equals(operator)) {
                    pass = Validator.runConcatenationTest(testVal, result, testNum);
                } else if ("%".equals(operator)) {
                    returnType = Double.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, expectedVal);
                } else if (testNum instanceof BigInteger) {
                    returnType = BigDecimal.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue(((BigDecimal)result).doubleValue(), expectedVal);
                } else {
                    returnType = Double.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, expectedVal);
                }
            }
            catch (RuntimeException re) {
                ELTestUtil.printStackTrace(re);
                throw new Exception(re);
            }
            catch (Exception e) {
                ELTestUtil.printStackTrace(e);
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                logger.log(System.Logger.Level.INFO, "*** End \"Double\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testNumericString(String testVal, Double expectedVal, String operator) throws Exception {
        boolean pass = false;
        for (int i = 0; TestNum.getNumberList().size() > i; ++i) {
            logger.log(System.Logger.Level.INFO, "*** Start \"NumericString\"Test Sequence ***");
            Object testNum = TestNum.getNumberList().get(i);
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            if (testNum instanceof BigDecimal || testNum instanceof Float || testNum instanceof Double) {
                String skipType = testNum.getClass().getSimpleName();
                logger.log(System.Logger.Level.INFO, "Skip " + skipType + " Data type already tested for this in the " + skipType + " tests.");
                continue;
            }
            try {
                String expr = ExprEval.buildElExpr(true, operator);
                logger.log(System.Logger.Level.INFO, "expression to be evaluated is " + expr);
                logger.log(System.Logger.Level.INFO, "types are String and " + testNum.getClass().getName());
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                logger.log(System.Logger.Level.INFO, "result is " + result.toString());
                if ("%".equals(operator)) {
                    returnType = Double.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, expectedVal);
                } else if (testNum instanceof BigInteger) {
                    returnType = BigDecimal.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue(((BigDecimal)result).doubleValue(), expectedVal);
                } else {
                    returnType = Double.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, expectedVal);
                }
            }
            catch (RuntimeException re) {
                ELTestUtil.printStackTrace(re);
                throw new Exception(re);
            }
            catch (Exception e) {
                ELTestUtil.printStackTrace(e);
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                logger.log(System.Logger.Level.INFO, "*** End \"NumericString\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testBigInteger(BigInteger testVal, Object expectedVal, String operator) throws Exception {
        boolean pass = false;
        for (int i = 0; TestNum.getNumberList().size() > i; ++i) {
            logger.log(System.Logger.Level.INFO, "*** Start \"BigInteger\" Test Sequence ***");
            Object testNum = TestNum.getNumberList().get(i);
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            if (testNum instanceof BigDecimal || testNum instanceof Float || testNum instanceof Double || testNum instanceof String) {
                String skipType = testNum.getClass().getSimpleName();
                logger.log(System.Logger.Level.INFO, "Skip " + skipType + " Data type already tested for this in the " + skipType + " tests.");
                continue;
            }
            try {
                String expr = ExprEval.buildElExpr(true, operator);
                logger.log(System.Logger.Level.INFO, "expression to be evaluated is " + expr);
                logger.log(System.Logger.Level.INFO, "types are BigInteger and " + testNum.getClass().getName());
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                logger.log(System.Logger.Level.INFO, "result is " + result.toString());
                if ("+=".equals(operator)) {
                    pass = Validator.runConcatenationTest(testVal, result, testNum);
                } else if ("/".equals(operator)) {
                    returnType = BigDecimal.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((BigDecimal)result, BigDecimal.valueOf(((BigInteger)expectedVal).doubleValue()), 0);
                } else {
                    returnType = BigInteger.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((BigInteger)result, (BigInteger)expectedVal, 0);
                }
            }
            catch (RuntimeException re) {
                ELTestUtil.printStackTrace(re);
                throw new Exception(re);
            }
            catch (Exception e) {
                ELTestUtil.printStackTrace(e);
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                logger.log(System.Logger.Level.INFO, "*** End \"BigInteger\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testLong(Long testVal, Object expectedVal, String operator) throws Exception {
        boolean pass = false;
        for (int i = 0; TestNum.getNumberList().size() > i; ++i) {
            logger.log(System.Logger.Level.INFO, "*** Start \"Long\" Test Sequence ***");
            Object testNum = TestNum.getNumberList().get(i);
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            if (testNum instanceof BigDecimal || testNum instanceof Float || testNum instanceof Double || testNum instanceof String || testNum instanceof BigInteger) {
                String skipType = testNum.getClass().getSimpleName();
                logger.log(System.Logger.Level.INFO, "Skip " + skipType + " Data type already tested for this in the " + skipType + " tests.");
                continue;
            }
            try {
                String expr = ExprEval.buildElExpr(true, operator);
                logger.log(System.Logger.Level.INFO, "expression to be evaluated is " + expr);
                logger.log(System.Logger.Level.INFO, "types are  Long and " + testNum.getClass().getName());
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                logger.log(System.Logger.Level.INFO, "result is " + result.toString());
                if ("+=".equals(operator)) {
                    pass = Validator.runConcatenationTest(testVal, result, testNum);
                } else if ("/".equals(operator)) {
                    returnType = Double.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, ((Long)expectedVal).doubleValue());
                } else {
                    returnType = Long.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Long)result, (Long)expectedVal, 0);
                }
            }
            catch (RuntimeException re) {
                ELTestUtil.printStackTrace(re);
                throw new Exception(re);
            }
            catch (Exception e) {
                ELTestUtil.printStackTrace(e);
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                logger.log(System.Logger.Level.INFO, "*** End \"Long\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testInteger(Integer testVal, Object expectedVal, String operator) throws Exception {
        boolean pass = false;
        for (int i = 0; TestNum.getNumberList().size() > i; ++i) {
            logger.log(System.Logger.Level.INFO, "*** Start \"Integer\" Test Sequence ***");
            Object testNum = TestNum.getNumberList().get(i);
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            if (testNum instanceof BigDecimal || testNum instanceof Float || testNum instanceof Double || testNum instanceof String || testNum instanceof Long || testNum instanceof BigInteger) {
                String skipType = testNum.getClass().getSimpleName();
                logger.log(System.Logger.Level.INFO, "Skip " + skipType + " Data type already tested for this in the " + skipType + " tests.");
                continue;
            }
            try {
                String expr = ExprEval.buildElExpr(true, operator);
                logger.log(System.Logger.Level.INFO, "expression to be evaluated is " + expr);
                logger.log(System.Logger.Level.INFO, "types are  Integer and " + testNum.getClass().getName());
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                logger.log(System.Logger.Level.INFO, "result is " + result.toString());
                if ("+=".equals(operator)) {
                    pass = Validator.runConcatenationTest(testVal, result, testNum);
                } else if ("/".equals(operator)) {
                    returnType = Double.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, ((Integer)expectedVal).doubleValue());
                } else {
                    returnType = Long.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Long)result, ((Integer)expectedVal).longValue());
                }
            }
            catch (RuntimeException re) {
                ELTestUtil.printStackTrace(re);
                throw new Exception(re);
            }
            catch (Exception e) {
                ELTestUtil.printStackTrace(e);
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                logger.log(System.Logger.Level.INFO, "*** End \"Integer\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testShort(Short testVal, Object expectedVal, String operator) throws Exception {
        boolean pass = false;
        for (int i = 0; TestNum.getNumberList().size() > i; ++i) {
            logger.log(System.Logger.Level.INFO, "*** Start \"Short\" Test Sequence ***");
            Object testNum = TestNum.getNumberList().get(i);
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            if (!(testNum instanceof Short) && !(testNum instanceof Byte)) {
                String skipType = testNum.getClass().getSimpleName();
                logger.log(System.Logger.Level.INFO, "Skip " + skipType + " Data type already tested for this in the " + skipType + " tests.");
                continue;
            }
            try {
                String expr = ExprEval.buildElExpr(true, operator);
                logger.log(System.Logger.Level.INFO, "expression to be evaluated is " + expr);
                logger.log(System.Logger.Level.INFO, "types are  Short and " + testNum.getClass().getName());
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                logger.log(System.Logger.Level.INFO, "result is " + result.toString());
                if ("+=".equals(operator)) {
                    pass = Validator.runConcatenationTest(testVal, result, testNum);
                } else if ("/".equals(operator)) {
                    returnType = Double.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, ((Short)expectedVal).doubleValue());
                } else {
                    returnType = Long.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Long)result, ((Short)expectedVal).longValue());
                }
            }
            catch (RuntimeException re) {
                ELTestUtil.printStackTrace(re);
                throw new Exception(re);
            }
            catch (Exception e) {
                ELTestUtil.printStackTrace(e);
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                logger.log(System.Logger.Level.INFO, "*** End \"Short\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testByte(Byte testVal, Object expectedVal, String operator) throws Exception {
        boolean pass = false;
        for (int i = 0; TestNum.getNumberList().size() > i; ++i) {
            logger.log(System.Logger.Level.INFO, "*** Start \"Byte\" Test Sequence ***");
            Object testNum = TestNum.getNumberList().get(i);
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            if (!(testNum instanceof Byte)) {
                String skipType = testNum.getClass().getSimpleName();
                logger.log(System.Logger.Level.INFO, "Skip " + skipType + " Data type already tested for this in the " + skipType + " tests.");
                continue;
            }
            try {
                String expr = ExprEval.buildElExpr(true, operator);
                logger.log(System.Logger.Level.INFO, "expression to be evaluated is " + expr);
                logger.log(System.Logger.Level.INFO, "types are  Byte and " + testNum.getClass().getName());
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                logger.log(System.Logger.Level.INFO, "result is " + result.toString());
                if ("+=".equals(operator)) {
                    pass = Validator.runConcatenationTest(testVal, result, testNum);
                } else if ("/".equals(operator)) {
                    returnType = Double.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Double)result, ((Byte)expectedVal).doubleValue());
                } else {
                    returnType = Long.class;
                    logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getCanonicalName());
                    pass = ExprEval.compareClass(result, returnType) && ExprEval.compareValue((Long)result, ((Byte)expectedVal).longValue());
                }
            }
            catch (RuntimeException re) {
                ELTestUtil.printStackTrace(re);
                throw new Exception(re);
            }
            catch (Exception e) {
                ELTestUtil.printStackTrace(e);
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                logger.log(System.Logger.Level.INFO, "*** End \"Byte\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testBoolean(boolean testValOne, Object testValTwo, Object expectedVal, String operator) throws Exception {
        boolean pass = false;
        NameValuePair[] values = NameValuePair.buildNameValuePair(testValOne, testValTwo);
        try {
            logger.log(System.Logger.Level.INFO, "*** Start \"Boolean\" Test Sequence ***");
            String expr = ExprEval.buildElExpr(true, operator);
            logger.log(System.Logger.Level.INFO, "expression to be evaluated is " + expr);
            logger.log(System.Logger.Level.INFO, "types are  Boolean and " + testValTwo.getClass().getName());
            Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
            if ("+=".equals(operator)) {
                pass = Validator.runConcatenationTest(testValOne, result, testValTwo);
            } else {
                logger.log(System.Logger.Level.INFO, "result is " + result.toString());
                pass = ExprEval.compareClass(result, Boolean.class) && ExprEval.compareValue((Object)((Boolean)result), expectedVal);
            }
        }
        catch (RuntimeException re) {
            ELTestUtil.printStackTrace(re);
            throw new Exception(re);
        }
        catch (Exception e) {
            ELTestUtil.printStackTrace(e);
            throw new Exception(e);
        }
        finally {
            ExprEval.cleanup();
            logger.log(System.Logger.Level.INFO, "*** End \"Boolean\" Test Sequence ***");
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    public static void testExpression(ELProcessor elp, String expr, Object expected, String testName) throws Exception {
        boolean pass = false;
        try {
            logger.log(System.Logger.Level.INFO, "*** Start " + testName + " Test Sequence ***");
            logger.log(System.Logger.Level.INFO, "expression to be evaluated is " + expr);
            Object result = elp.eval(expr);
            boolean bl = pass = ExprEval.compareClass(result, expected.getClass()) && ExprEval.compareValue(result, expected);
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (RuntimeException re) {
            ELTestUtil.printStackTrace(re);
            throw new Exception(re);
        }
        catch (Exception e) {
            ELTestUtil.printStackTrace(e);
            throw new Exception(e);
        }
        finally {
            ExprEval.cleanup();
            logger.log(System.Logger.Level.INFO, "*** End " + testName + " Test Sequence ***");
        }
    }

    private static Boolean runConcatenationTest(Object testVal, Object result, Object testNum) {
        Class<String> returnType = String.class;
        String expectedResult = testVal.toString() + testNum.toString();
        logger.log(System.Logger.Level.INFO, "Setting Expected Type: " + returnType.getName());
        return ExprEval.compareClass(result, returnType) && ExprEval.compareValue(result, expectedResult);
    }
}

