/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDIFDeleteChangeRecord
extends LDIFChangeRecord {
    private static final long serialVersionUID = 9173178539060889790L;

    public LDIFDeleteChangeRecord(String dn) {
        this(dn, null);
    }

    public LDIFDeleteChangeRecord(String dn, List<Control> controls) {
        super(dn, controls);
    }

    public LDIFDeleteChangeRecord(DeleteRequest deleteRequest) {
        super(deleteRequest.getDN(), deleteRequest.getControlList());
    }

    public DeleteRequest toDeleteRequest() {
        return this.toDeleteRequest(true);
    }

    public DeleteRequest toDeleteRequest(boolean includeControls) {
        DeleteRequest deleteRequest = new DeleteRequest(this.getDN());
        if (includeControls) {
            deleteRequest.setControls(this.getControls());
        }
        return deleteRequest;
    }

    @Override
    public ChangeType getChangeType() {
        return ChangeType.DELETE;
    }

    @Override
    public LDAPResult processChange(LDAPInterface connection, boolean includeControls) throws LDAPException {
        return connection.delete(this.toDeleteRequest(includeControls));
    }

    @Override
    public String[] toLDIF(int wrapColumn) {
        List<String> ldifLines = new ArrayList<String>(5);
        LDIFDeleteChangeRecord.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), ldifLines);
        for (Control c : this.getControls()) {
            LDIFDeleteChangeRecord.encodeNameAndValue("control", LDIFDeleteChangeRecord.encodeControlString(c), ldifLines);
        }
        ldifLines.add("changetype: delete");
        if (wrapColumn > 2) {
            ldifLines = LDIFWriter.wrapLines(wrapColumn, ldifLines);
        }
        String[] ldifArray = new String[ldifLines.size()];
        ldifLines.toArray(ldifArray);
        return ldifArray;
    }

    @Override
    public void toLDIF(ByteStringBuffer buffer, int wrapColumn) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL_BYTES);
        for (Control c : this.getControls()) {
            LDIFWriter.encodeNameAndValue("control", LDIFDeleteChangeRecord.encodeControlString(c), buffer, wrapColumn);
            buffer.append(StaticUtils.EOL_BYTES);
        }
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("delete"), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL_BYTES);
    }

    @Override
    public void toLDIFString(StringBuilder buffer, int wrapColumn) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL);
        for (Control c : this.getControls()) {
            LDIFWriter.encodeNameAndValue("control", LDIFDeleteChangeRecord.encodeControlString(c), buffer, wrapColumn);
            buffer.append(StaticUtils.EOL);
        }
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("delete"), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL);
    }

    @Override
    public int hashCode() {
        try {
            return this.getParsedDN().hashCode();
        }
        catch (Exception e) {
            Debug.debugException(e);
            return StaticUtils.toLowerCase(this.getDN()).hashCode();
        }
    }

    @Override
    public boolean equals(Object o) {
        HashSet<Control> c2;
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof LDIFDeleteChangeRecord)) {
            return false;
        }
        LDIFDeleteChangeRecord r = (LDIFDeleteChangeRecord)o;
        HashSet<Control> c1 = new HashSet<Control>(this.getControls());
        if (!c1.equals(c2 = new HashSet<Control>(r.getControls()))) {
            return false;
        }
        try {
            return this.getParsedDN().equals(r.getParsedDN());
        }
        catch (Exception e) {
            Debug.debugException(e);
            return StaticUtils.toLowerCase(this.getDN()).equals(StaticUtils.toLowerCase(r.getDN()));
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDIFDeleteChangeRecord(dn='");
        buffer.append(this.getDN());
        buffer.append('\'');
        List<Control> controls = this.getControls();
        if (!controls.isEmpty()) {
            buffer.append(", controls={");
            Iterator<Control> iterator = controls.iterator();
            while (iterator.hasNext()) {
                iterator.next().toString(buffer);
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

