/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */


/*
 *  @(#)PropertyException.test.xml	1.2 02/11/19 Evgueni Rouban
 * Generated from : api/jakarta_xml/bind/PropertyException/PropertyException.test.xml
 *
 * General tests of constructors and methods
 * General tests of constructors and methods.
 */

package javasoft.sqe.tests.api.jakarta.xml.bind.PropertyException;

import jakarta.xml.bind.PropertyException;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.MultiTest;


public class PropertyExceptionTests extends MultiTest {

    static final String msg = "test message";
    static final String err = "error code";
    static final Throwable linkedException = new Throwable();

    class ToStringDetector {
        String str;
        public boolean detected;
        public ToStringDetector(String str) {
            this.str = str;
        }
        public String toString() {
            detected = true;
            return str;
        }

    }

    /* standalone interface */
    public static void main(String argv[]) {
        PropertyExceptionTests test = new PropertyExceptionTests();
        test.run(argv, System.err, System.out).exit();
    }

    /**
     * Assertion testing
     * for public PropertyException(java.lang.String message),
     * Construct a PropertyException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor001() {
        PropertyException pe = new PropertyException(msg);
        if (pe.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + pe.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public PropertyException(java.lang.String message),
     * The errorCode will default to null..
     * <br><b>Expected results</b>: errorCode is null
     */
    public Status Ctor002() {
        PropertyException pe = new PropertyException(msg);
        if (pe.getErrorCode() != null) {
            return Status.failed("getErrorCode() != null: \""
                               + pe.getErrorCode() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public PropertyException(java.lang.String message),
     * The linkedException will default to null..
     * <br><b>Expected results</b>: linkedException is null
     */
    public Status Ctor003() {
        PropertyException pe = new PropertyException(msg);
        if (pe.getLinkedException() != null) {
            return Status.failed("getLinkedException() != null: \""
                               + pe.getLinkedException() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public PropertyException(java.lang.String message, java.lang.String errorCode),
     * Construct a PropertyException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor004() {
        PropertyException pe = new PropertyException(msg, err);
        if (pe.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + pe.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public PropertyException(java.lang.String message, java.lang.String errorCode),
     * Construct a PropertyException with the specified errorCode..
     * <br><b>Expected results</b>: the errorCode is what set
     */
    public Status Ctor005() {
        PropertyException pe = new PropertyException(msg, err);
        if (pe.getErrorCode() != err) {
            return Status.failed("getErrorCode() != err: \""
                               + pe.getErrorCode() + "\", expected is \"" + err + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public PropertyException(java.lang.String message, java.lang.String errorCode),
     * The linkedException will default to null..
     * <br><b>Expected results</b>: linkedException is null
     */
    public Status Ctor006() {
        PropertyException pe = new PropertyException(msg, err);
        if (pe.getLinkedException() != null) {
            return Status.failed("getLinkedException() != null: \""
                               + pe.getLinkedException() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public PropertyException(java.lang.String message, java.lang.String errorCode, java.lang.Throwable exception),
     * Construct a PropertyException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor007() {
        PropertyException pe = new PropertyException(msg, err, linkedException);
        if (pe.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + pe.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public PropertyException(java.lang.String message, java.lang.String errorCode, java.lang.Throwable exception),
     * Construct a PropertyException with the specified errorCode..
     * <br><b>Expected results</b>: the errorCode is what set
     */
    public Status Ctor008() {
        PropertyException pe = new PropertyException(msg, err, linkedException);
        if (pe.getErrorCode() != err) {
            return Status.failed("getErrorCode() != err: \""
                               + pe.getErrorCode() + "\", expected is \"" + err + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public PropertyException(java.lang.String message, java.lang.String errorCode, java.lang.Throwable exception),
     * Construct a PropertyException with the specified linkedException..
     * <br><b>Expected results</b>: linkedException is what set
     */
    public Status Ctor009() {
        PropertyException pe = new PropertyException(msg, err, linkedException);
        if (pe.getLinkedException() != linkedException) {
            return Status.failed("getLinkedException() != linkedException: \""
                               + pe.getLinkedException() + "\", expected is \"" + linkedException + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public PropertyException(java.lang.String message, java.lang.Throwable exception),
     * Construct a PropertyException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor010() {
        PropertyException pe = new PropertyException(msg, linkedException);
        if (pe.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + pe.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public PropertyException(java.lang.String message, java.lang.Throwable exception),
     * The errorCode will default to null..
     * <br><b>Expected results</b>: errorCode is null
     */
    public Status Ctor011() {
        PropertyException pe = new PropertyException(msg, linkedException);
        if (pe.getErrorCode() != null) {
            return Status.failed("getErrorCode() != null: \""
                               + pe.getErrorCode() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public PropertyException(java.lang.String message, java.lang.Throwable exception),
     * Construct a PropertyException with the specified linkedException..
     * <br><b>Expected results</b>: linkedException is what set
     */
    public Status Ctor012() {
        PropertyException pe = new PropertyException(msg, linkedException);
        if (pe.getLinkedException() != linkedException) {
            return Status.failed("getLinkedException() != linkedException: \""
                               + pe.getLinkedException() + "\", expected is \"" + linkedException + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public PropertyException(java.lang.Throwable exception),
     * The detail message will default to null..
     * <br><b>Expected results</b>: the message is null
     */
    public Status Ctor013() {
        PropertyException pe = new PropertyException(linkedException);
        if (pe.getMessage() != null) {
            return Status.failed("getMessage() != null: \""
                               + pe.getMessage() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public PropertyException(java.lang.Throwable exception),
     * The errorCode will default to null..
     * <br><b>Expected results</b>: errorCode is null
     */
    public Status Ctor014() {
        PropertyException pe = new PropertyException(linkedException);
        if (pe.getErrorCode() != null) {
            return Status.failed("getErrorCode() != null: \""
                               + pe.getErrorCode() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public PropertyException(java.lang.Throwable exception),
     * Construct a PropertyException with the specified linkedException..
     * <br><b>Expected results</b>: linkedException is what set
     */
    public Status Ctor015() {
        PropertyException pe = new PropertyException(linkedException);
        if (pe.getLinkedException() != linkedException) {
            return Status.failed("getLinkedException() != linkedException: \""
                               + pe.getLinkedException() + "\", expected is \"" + linkedException + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public PropertyException(java.lang.String name, java.lang.Object value),
     * Construct a PropertyException with the message field set based on the name of the
     * property and value.toString()..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor016() {
        ToStringDetector tsd = new ToStringDetector("Ctor016");
        PropertyException pe = new PropertyException(msg, tsd);
        if (!tsd.detected) {
            return Status.failed("constructor PropertyException(msg, tsd) does not call"
                               + "tsd.toString() method");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public PropertyException(java.lang.String name, java.lang.Object value),
     * The errorCode will default to null..
     * <br><b>Expected results</b>: errorCode is null
     */
    public Status Ctor017() {
        PropertyException pe = new PropertyException(msg, new Object());
        if (pe.getErrorCode() != null) {
            return Status.failed("getErrorCode() != null: \""
                               + pe.getErrorCode() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public PropertyException(java.lang.String name, java.lang.Object value),
     * The linkedException will default to null..
     * <br><b>Expected results</b>: linkedException is null
     */
    public Status Ctor018() {
        PropertyException pe = new PropertyException(msg, new Object());
        if (pe.getLinkedException() != null) {
            return Status.failed("getLinkedException() != null: \""
                               + pe.getLinkedException() + "\"");
        }

        return Status.passed("OKAY");
    }
}
