/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.correction;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.correction.AbstractQuickFixTest;
import org.eclipse.lsp4j.Range;

public class AbstractSelectionTest
extends AbstractQuickFixTest {
    public static final String SQUARE_BRACKET_OPEN = "/*[*/";
    public static final int SQUARE_BRACKET_OPEN_LENGTH = "/*[*/".length();
    public static final String SQUARE_BRACKET_CLOSE = "/*]*/";
    public static final int SQUARE_BRACKET_CLOSE_LENGTH = "/*]*/".length();
    protected static final int VALID_SELECTION = 1;
    protected static final int INVALID_SELECTION = 2;
    protected static final int COMPARE_WITH_OUTPUT = 3;

    protected int[] getSelection(String source) {
        int start = -1;
        int end = -1;
        int includingStart = source.indexOf(SQUARE_BRACKET_OPEN);
        int excludingStart = source.indexOf(SQUARE_BRACKET_CLOSE);
        int includingEnd = source.lastIndexOf(SQUARE_BRACKET_CLOSE);
        int excludingEnd = source.lastIndexOf(SQUARE_BRACKET_OPEN);
        if (includingStart > excludingStart && excludingStart != -1) {
            includingStart = -1;
        } else if (excludingStart > includingStart && includingStart != -1) {
            excludingStart = -1;
        }
        if (includingEnd < excludingEnd) {
            includingEnd = -1;
        } else if (excludingEnd < includingEnd) {
            excludingEnd = -1;
        }
        start = includingStart != -1 ? includingStart : excludingStart + SQUARE_BRACKET_CLOSE_LENGTH;
        end = excludingEnd != -1 ? excludingEnd : includingEnd + SQUARE_BRACKET_CLOSE_LENGTH;
        return new int[]{start, end - start};
    }

    @Override
    protected Range getRange(ICompilationUnit cu, IProblem[] problems) throws JavaModelException {
        int[] ranges = this.getSelection(cu.getSource());
        return JDTUtils.toRange((IOpenable)cu, (int)ranges[0], (int)ranges[1]);
    }
}

