/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.ls.core.internal.ClassFileUtil;
import org.eclipse.jdt.ls.core.internal.Lsp4jAssertions;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.handlers.DocumentHighlightHandler;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DocumentHighlightHandlerTest
extends AbstractProjectsManagerBasedTest {
    private IProject project;
    private DocumentHighlightHandler handler;

    private void assertHighlight(DocumentHighlight highlight, int expectedLine, int expectedStart, int expectedEnd, DocumentHighlightKind expectedKind) {
        Lsp4jAssertions.assertRange(expectedLine, expectedStart, expectedEnd, highlight.getRange());
        Assert.assertEquals((Object)expectedKind, (Object)highlight.getKind());
    }

    @Before
    public void setup() throws Exception {
        this.importProjects("eclipse/hello");
        this.project = WorkspaceHelper.getProject("hello");
        this.handler = new DocumentHighlightHandler();
    }

    @Test
    public void testDocumentHighlightHandler() throws Exception {
        String uri = ClassFileUtil.getURI(this.project, "org.sample.Highlight");
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(uri);
        TextDocumentPositionParams params = new TextDocumentPositionParams(identifier, new Position(5, 10));
        List highlights = this.handler.documentHighlight(params, this.monitor);
        Assert.assertEquals((long)4L, (long)highlights.size());
        this.assertHighlight((DocumentHighlight)highlights.get(0), 5, 9, 15, DocumentHighlightKind.Write);
        this.assertHighlight((DocumentHighlight)highlights.get(1), 6, 2, 8, DocumentHighlightKind.Read);
        this.assertHighlight((DocumentHighlight)highlights.get(2), 7, 2, 8, DocumentHighlightKind.Write);
        this.assertHighlight((DocumentHighlight)highlights.get(3), 8, 2, 8, DocumentHighlightKind.Read);
    }
}

