/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.net.URI;
import java.nio.file.Paths;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ls.core.internal.ClassFileUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JsonMessageHelper;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.handlers.HoverHandler;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class HoverHandlerTest
extends AbstractProjectsManagerBasedTest {
    private static String HOVER_TEMPLATE = "{\n    \"id\": \"1\",\n    \"method\": \"textDocument/hover\",\n    \"params\": {\n        \"textDocument\": {\n            \"uri\": \"${file}\"\n        },\n        \"position\": {\n            \"line\": ${line},\n            \"character\": ${char}\n        }\n    },\n    \"jsonrpc\": \"2.0\"\n}";
    private HoverHandler handler;
    private IProject project;
    private IPackageFragmentRoot sourceFolder;
    private PreferenceManager preferenceManager;

    @Before
    public void setup() throws Exception {
        this.importProjects("eclipse/hello");
        this.project = WorkspaceHelper.getProject("hello");
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        this.sourceFolder = javaProject.getPackageFragmentRoot((IResource)javaProject.getProject().getFolder("src"));
        this.preferenceManager = (PreferenceManager)Mockito.mock(PreferenceManager.class);
        Mockito.when((Object)this.preferenceManager.getPreferences()).thenReturn((Object)new Preferences());
        this.handler = new HoverHandler(this.preferenceManager);
    }

    @Test
    public void testHover() throws Exception {
        String payload = this.createHoverRequest("src/java/Foo.java", 5, 15);
        TextDocumentPositionParams position = (TextDocumentPositionParams)JsonMessageHelper.getParams(payload);
        Hover hover = this.handler.hover(position, this.monitor);
        Assert.assertNotNull((Object)hover);
        Assert.assertNotNull((Object)hover.getContents());
        MarkedString signature = (MarkedString)((Either)hover.getContents().get(0)).getRight();
        Assert.assertEquals((String)("Unexpected hover " + signature), (Object)"java", (Object)signature.getLanguage());
        Assert.assertEquals((String)("Unexpected hover " + signature), (Object)"java.Foo", (Object)signature.getValue());
        String doc = (String)((Either)hover.getContents().get(1)).getLeft();
        Assert.assertEquals((String)("Unexpected hover " + doc), (Object)"This is foo", (Object)doc);
    }

    @Test
    public void testHoverStandalone() throws Exception {
        URI standalone = Paths.get("projects", "maven", "salut", "src", "main", "java", "java", "Foo.java").toUri();
        String payload = this.createHoverRequest(standalone, 10, 71);
        TextDocumentPositionParams position = (TextDocumentPositionParams)JsonMessageHelper.getParams(payload);
        Hover hover = this.handler.hover(position, this.monitor);
        Assert.assertNotNull((Object)hover);
        Assert.assertNotNull((Object)hover.getContents());
        MarkedString signature = (MarkedString)((Either)hover.getContents().get(0)).getRight();
        Assert.assertEquals((String)("Unexpected hover " + signature), (Object)"java", (Object)signature.getLanguage());
        Assert.assertEquals((String)("Unexpected hover " + signature), (Object)"java.Foo", (Object)signature.getValue());
        String doc = (String)((Either)hover.getContents().get(1)).getLeft();
        Assert.assertEquals((String)("Unexpected hover " + doc), (Object)"This is foo", (Object)doc);
    }

    @Test
    public void testHoverPackage() throws Exception {
        String payload = this.createHoverRequest("src/java/Baz.java", 2, 16);
        TextDocumentPositionParams position = (TextDocumentPositionParams)JsonMessageHelper.getParams(payload);
        Hover hover = this.handler.hover(position, this.monitor);
        Assert.assertNotNull((Object)hover);
        String signature = ((MarkedString)((Either)hover.getContents().get(0)).getRight()).getValue();
        Assert.assertEquals((String)"Unexpected signature ", (Object)"java.internal", (Object)signature);
        String result = (String)((Either)hover.getContents().get(1)).getLeft();
        Assert.assertEquals((String)"Unexpected hover ", (Object)"this is a **bold** package!", (Object)result);
    }

    @Test
    public void testEmptyHover() throws Exception {
        URI standalone = Paths.get("projects", "maven", "salut", "src", "main", "java", "java", "Foo.java").toUri();
        String payload = this.createHoverRequest(standalone, 1, 2);
        TextDocumentPositionParams position = (TextDocumentPositionParams)JsonMessageHelper.getParams(payload);
        Hover hover = this.handler.hover(position, this.monitor);
        Assert.assertNotNull((Object)hover);
        Assert.assertNotNull((Object)hover.getContents());
        Assert.assertEquals((long)1L, (long)hover.getContents().size());
        Assert.assertEquals((String)("Should find empty hover for " + payload), (Object)"", (Object)((Either)hover.getContents().get(0)).getLeft());
    }

    String createHoverRequest(String file, int line, int kar) {
        URI uri = this.project.getFile(file).getRawLocationURI();
        return this.createHoverRequest(uri, line, kar);
    }

    String createHoverRequest(ICompilationUnit cu, int line, int kar) {
        URI uri = cu.getResource().getRawLocationURI();
        return this.createHoverRequest(uri, line, kar);
    }

    String createHoverRequest(URI file, int line, int kar) {
        String fileURI = ResourceUtils.fixURI((URI)file);
        return HOVER_TEMPLATE.replace("${file}", fileURI).replace("${line}", String.valueOf(line)).replace("${char}", String.valueOf(kar));
    }

    @Test
    public void testHoverVariable() throws Exception {
        String argParam = this.createHoverRequest("src/java/Foo.java", 7, 37);
        TextDocumentPositionParams position = (TextDocumentPositionParams)JsonMessageHelper.getParams(argParam);
        Hover hover = this.handler.hover(position, this.monitor);
        Assert.assertNotNull((Object)hover);
        Assert.assertNotNull((Object)hover.getContents());
        MarkedString signature = (MarkedString)((Either)hover.getContents().get(0)).getRight();
        Assert.assertEquals((String)("Unexpected hover " + signature), (Object)"java", (Object)signature.getLanguage());
        Assert.assertEquals((String)("Unexpected hover " + signature), (Object)"String[] args - java.Foo.main(String[])", (Object)signature.getValue());
    }

    @Test
    public void testHoverMethod() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("import java.util.Vector;\n");
        buf.append("public class E {\n");
        buf.append("   public int foo(String s) { }\n");
        buf.append("   public static void foo2(String s, String s2) { }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        Assert.assertEquals((Object)"int test1.E.foo(String s)", (Object)this.getTitleHover(cu, 3, 15));
        Assert.assertEquals((Object)"void test1.E.foo2(String s, String s2)", (Object)this.getTitleHover(cu, 4, 24));
    }

    @Test
    public void testHoverTypeParameters() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("import java.util.Vector;\n");
        buf.append("public class E<T> {\n");
        buf.append("   public T foo(T s) { }\n");
        buf.append("   public <U> U bar(U s) { }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        Assert.assertEquals((Object)"T", (Object)this.getTitleHover(cu, 3, 10));
        Assert.assertEquals((Object)"T test1.E.foo(T s)", (Object)this.getTitleHover(cu, 3, 13));
        Assert.assertEquals((Object)"<U> U test1.E.bar(U s)", (Object)this.getTitleHover(cu, 4, 17));
    }

    @Test
    public void testHoverInheritedJavadoc() throws Exception {
        String payload = this.createHoverRequest("src/java/Bar.java", 22, 19);
        TextDocumentPositionParams position = (TextDocumentPositionParams)JsonMessageHelper.getParams(payload);
        Hover hover = this.handler.hover(position, this.monitor);
        Assert.assertNotNull((Object)hover);
        String result = (String)((Either)hover.getContents().get(1)).getLeft();
        Assert.assertEquals((String)"Unexpected hover ", (Object)"This method comes from Foo", (Object)result);
    }

    @Test
    public void testHoverOverNullElement() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("import javax.xml.bind.Binder;\n");
        buf.append("public class E {}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        Hover hover = this.getHover(cu, 1, 8);
        Assert.assertNotNull((Object)hover);
        Assert.assertEquals((long)1L, (long)hover.getContents().size());
        Assert.assertEquals((String)"Unexpected hover ", (Object)"javax", (Object)((MarkedString)((Either)hover.getContents().get(0)).getRight()).getValue());
    }

    @Test
    public void testHoverOnPackageWithJavadoc() throws Exception {
        this.importProjects("maven/salut2");
        this.project = WorkspaceHelper.getProject("salut2");
        this.handler = new HoverHandler(this.preferenceManager);
        String payload = this.createHoverRequest("src/main/java/foo/Bar.java", 2, 22);
        TextDocumentPositionParams position = (TextDocumentPositionParams)JsonMessageHelper.getParams(payload);
        Hover hover = this.handler.hover(position, this.monitor);
        Assert.assertNotNull((Object)hover);
        String result = ((MarkedString)((Either)hover.getContents().get(0)).getRight()).getValue();
        Assert.assertEquals((String)"Unexpected hover ", (Object)"org.apache.commons", (Object)result);
        Assert.assertEquals((String)this.logListener.getErrors().toString(), (long)0L, (long)this.logListener.getErrors().size());
    }

    @Test
    public void testHoverThrowable() throws Exception {
        String uriString = ClassFileUtil.getURI(this.project, "java.lang.Exception");
        IClassFile classFile = JDTUtils.resolveClassFile((String)uriString);
        String contents = JavaLanguageServerPlugin.getContentProviderManager().getSource(classFile, this.monitor);
        Document document = new Document(contents);
        IRegion region = new FindReplaceDocumentAdapter((IDocument)document).find(0, "Throwable", true, false, false, false);
        int offset = region.getOffset();
        int line = document.getLineOfOffset(offset);
        int character = offset - document.getLineOffset(line);
        TextDocumentIdentifier textDocument = new TextDocumentIdentifier(uriString);
        Position position = new Position(line, character);
        TextDocumentPositionParams params = new TextDocumentPositionParams(textDocument, position);
        Hover hover = this.handler.hover(params, this.monitor);
        Assert.assertNotNull((Object)hover);
        Assert.assertTrue((String)"Unexpected hover ", (!hover.getContents().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testHoverUnresolvedType() throws Exception {
        this.importProjects("eclipse/unresolvedtype");
        this.project = WorkspaceHelper.getProject("unresolvedtype");
        this.handler = new HoverHandler(this.preferenceManager);
        String payload = this.createHoverRequest("src/pckg/Foo.java", 2, 31);
        TextDocumentPositionParams position = (TextDocumentPositionParams)JsonMessageHelper.getParams(payload);
        Hover hover = this.handler.hover(position, this.monitor);
        Assert.assertNotNull((Object)hover);
        Assert.assertTrue((String)"Unexpected hover ", (boolean)hover.getContents().isEmpty());
    }

    private String getTitleHover(ICompilationUnit cu, int line, int character) {
        Hover hover = this.getHover(cu, line, character);
        Assert.assertNotNull((Object)hover);
        MarkedString result = (MarkedString)((Either)hover.getContents().get(0)).getRight();
        return result.getValue();
    }

    private Hover getHover(ICompilationUnit cu, int line, int character) {
        String payload = this.createHoverRequest(cu, line, character);
        TextDocumentPositionParams position = (TextDocumentPositionParams)JsonMessageHelper.getParams(payload);
        return this.handler.hover(position, this.monitor);
    }
}

