/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.net.URI;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.ls.core.internal.ClassFileUtil;
import org.eclipse.jdt.ls.core.internal.FakeContentProvider;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.eclipse.jdt.ls.core.internal.managers.ContentProviderManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ContentProviderManagerTest
extends AbstractProjectsManagerBasedTest {
    private static final String FAKE_DECOMPILED_SOURCE = "This is decompiled";
    private URI sourcelessURI;
    private IClassFile sourcelessClassFile;
    private URI sourceAvailableURI;
    private IClassFile sourceAvailableClassFile;
    private PreferenceManager preferenceManager;
    private Preferences preferences;
    private ContentProviderManager provider;

    @Before
    public void createURIs() throws Exception {
        this.importProjects("maven/salut");
        IProject project = WorkspaceHelper.getProject("salut");
        this.sourcelessURI = JDTUtils.toURI((String)ClassFileUtil.getURI(project, "java.math.BigDecimal"));
        this.sourcelessClassFile = JDTUtils.resolveClassFile((URI)this.sourcelessURI);
        this.sourceAvailableURI = JDTUtils.toURI((String)ClassFileUtil.getURI(project, "org.apache.commons.lang3.text.WordUtils"));
        this.sourceAvailableClassFile = JDTUtils.resolveClassFile((URI)this.sourceAvailableURI);
    }

    @Before
    public void buildContentProviderManager() {
        this.preferenceManager = (PreferenceManager)Mockito.mock(PreferenceManager.class);
        this.preferences = (Preferences)Mockito.mock(Preferences.class);
        Mockito.when((Object)this.preferences.getPreferredContentProviderIds()).thenReturn(null);
        Mockito.when((Object)this.preferenceManager.getPreferences()).thenReturn((Object)this.preferences);
        this.provider = new ContentProviderManager(this.preferenceManager);
    }

    @Before
    @After
    public void resetFakeContentProvider() {
        FakeContentProvider.preferences = null;
        FakeContentProvider.returnValue = null;
    }

    @Before
    public void resetMonitor() {
        this.monitor.setCanceled(false);
    }

    @Test
    public void testOpenSourceCode() throws Exception {
        String result = this.provider.getContent(this.sourceAvailableURI, this.monitor);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)("unexpected body content " + result), (boolean)result.contains("Operations on Strings that contain words."));
    }

    @Test
    public void testDecompileSourceCode() throws Exception {
        String result = this.provider.getSource(this.sourceAvailableClassFile, this.monitor);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)("unexpected body content " + result), (boolean)result.contains("Operations on Strings that contain words."));
    }

    @Test
    public void testOpenMissingFile() throws Exception {
        URI noSuchURI = JDTUtils.toURI((String)"file://this/is/Missing.class");
        String result = this.provider.getContent(noSuchURI, this.monitor);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)("not empty: " + result), (boolean)result.isEmpty());
    }

    @Test
    public void testOpenThingy() throws Exception {
        FakeContentProvider.returnValue = FAKE_DECOMPILED_SOURCE;
        URI noSuchURI = JDTUtils.toURI((String)"file://this/is/Some.thingy");
        Assert.assertEquals((Object)FAKE_DECOMPILED_SOURCE, (Object)this.provider.getContent(noSuchURI, this.monitor));
    }

    @Test
    public void testOpenNothing() throws Exception {
        String result = this.provider.getContent(null, this.monitor);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testDecompileNothing() throws Exception {
        String result = this.provider.getSource(null, this.monitor);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testThrowsException() throws Exception {
        FakeContentProvider.returnValue = new Exception("Something bad happened here");
        String result = this.provider.getContent(this.sourcelessURI, this.monitor);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)("disassembler header is missing from " + result), (boolean)result.startsWith(" // Failed to get sources. Instead, stub sources have been generated by the disassembler.\n // Implementation of methods is unavailable.\n"));
        this.expectLoggedError("Something bad happened here");
    }

    @Test
    public void testDecompileThrowsException() throws Exception {
        FakeContentProvider.returnValue = new Exception("Something bad happened here");
        String result = this.provider.getSource(this.sourcelessClassFile, this.monitor);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)("disassembler header is missing from " + result), (boolean)result.startsWith(" // Failed to get sources. Instead, stub sources have been generated by the disassembler.\n // Implementation of methods is unavailable.\n"));
        this.expectLoggedError("Something bad happened here");
    }

    @Test
    public void testDefaultOrder() throws Exception {
        String result = this.provider.getContent(this.sourcelessURI, this.monitor);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)("disassembler header is missing from " + result), (boolean)result.startsWith(" // Failed to get sources. Instead, stub sources have been generated by the disassembler.\n // Implementation of methods is unavailable.\n"));
        this.expectLoggedError("You have more than one content provider installed:");
    }

    @Test
    public void testDecompileDefaultOrder() throws Exception {
        String result = this.provider.getSource(this.sourcelessClassFile, this.monitor);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)("disassembler header is missing from " + result), (boolean)result.startsWith(" // Failed to get sources. Instead, stub sources have been generated by the disassembler.\n // Implementation of methods is unavailable.\n"));
        this.expectLoggedError("You have more than one content provider installed:");
    }

    @Test
    public void testPreferExistingProviderClass() {
        FakeContentProvider.returnValue = FAKE_DECOMPILED_SOURCE;
        Mockito.when((Object)this.preferences.getPreferredContentProviderIds()).thenReturn(Arrays.asList("fakeContentProvider", "placeholderContentProvider"));
        Assert.assertEquals((Object)FAKE_DECOMPILED_SOURCE, (Object)this.provider.getContent(this.sourcelessURI, this.monitor));
        Assert.assertTrue((String)this.logListener.getErrors().toString(), (boolean)this.logListener.getErrors().isEmpty());
    }

    @Test
    public void testDecompilePreferExistingProviderClass() {
        FakeContentProvider.returnValue = FAKE_DECOMPILED_SOURCE;
        Mockito.when((Object)this.preferences.getPreferredContentProviderIds()).thenReturn(Arrays.asList("fakeContentProvider", "placeholderContentProvider"));
        Assert.assertEquals((Object)FAKE_DECOMPILED_SOURCE, (Object)this.provider.getSource(this.sourcelessClassFile, this.monitor));
        Assert.assertTrue((String)this.logListener.getErrors().toString(), (boolean)this.logListener.getErrors().isEmpty());
    }

    @Test
    public void testPreferNonexistingProviderClass() {
        Mockito.when((Object)this.preferences.getPreferredContentProviderIds()).thenReturn(Arrays.asList("placeholderContentProvider"));
        String result = this.provider.getContent(this.sourcelessURI, this.monitor);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)("disassembler header is missing from " + result), (boolean)result.startsWith(" // Failed to get sources. Instead, stub sources have been generated by the disassembler.\n // Implementation of methods is unavailable.\n"));
        this.expectLoggedError("Unable to load IContentProvider class for placeholderContentProvider");
    }

    @Test
    public void testDecompilePreferNonexistingProviderClass() {
        Mockito.when((Object)this.preferences.getPreferredContentProviderIds()).thenReturn(Arrays.asList("placeholderContentProvider"));
        String result = this.provider.getSource(this.sourcelessClassFile, this.monitor);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)("disassembler header is missing from " + result), (boolean)result.startsWith(" // Failed to get sources. Instead, stub sources have been generated by the disassembler.\n // Implementation of methods is unavailable.\n"));
        this.expectLoggedError("Unable to load IDecompiler class for placeholderContentProvider");
    }

    @Test
    public void testPreferUnknownExtension() {
        Mockito.when((Object)this.preferences.getPreferredContentProviderIds()).thenReturn(Arrays.asList("unknownContentProvider"));
        String result = this.provider.getContent(this.sourcelessURI, this.monitor);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)("disassembler header is missing from " + result), (boolean)result.startsWith(" // Failed to get sources. Instead, stub sources have been generated by the disassembler.\n // Implementation of methods is unavailable.\n"));
    }

    @Test
    public void testPreferDisassembler() throws Exception {
        Mockito.when((Object)this.preferences.getPreferredContentProviderIds()).thenReturn(Arrays.asList("disassemblerContentProvider"));
        String result = this.provider.getContent(this.sourcelessURI, this.monitor);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)("disassembler header is missing from " + result), (boolean)result.startsWith(" // Failed to get sources. Instead, stub sources have been generated by the disassembler.\n // Implementation of methods is unavailable.\n"));
        Assert.assertTrue((String)("unexpected body content " + result), (boolean)result.contains("public class BigDecimal extends java.lang.Number implements java.lang.Comparable {"));
    }

    @Test
    public void testCancelMonitor() {
        FakeContentProvider.returnValue = this.monitor;
        String result = this.provider.getContent(this.sourcelessURI, this.monitor);
        Assert.assertTrue((boolean)this.monitor.isCanceled());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)"not empty", (boolean)result.isEmpty());
    }

    @Test
    public void testExpectPreferences() {
        this.provider.getContent(this.sourcelessURI, this.monitor);
        Assert.assertEquals((String)"preferences not set", (Object)this.preferences, (Object)FakeContentProvider.preferences);
    }

    @Test
    public void testNoCaching() {
        FakeContentProvider.returnValue = "some value";
        Assert.assertEquals((Object)FakeContentProvider.returnValue, (Object)this.provider.getContent(this.sourcelessURI, this.monitor));
        FakeContentProvider.returnValue = "something else";
        Assert.assertEquals((Object)FakeContentProvider.returnValue, (Object)this.provider.getContent(this.sourcelessURI, this.monitor));
    }

    private void expectLoggedError(String expected) {
        Assert.assertTrue((String)("expected error " + expected), (boolean)this.logListener.getErrors().stream().filter(e -> e.contains(expected)).findAny().isPresent());
    }
}

