/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphing.ui.datadisplay;

import java.text.MessageFormat;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.GraphingUIPlugin;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.Localization;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.wizards.filter.AvailableFilterTypes;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.wizards.filter.SelectFilterWizard;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.IFilteredDataSet;
import org.eclipse.linuxtools.systemtap.graphing.core.filters.IDataSetFilter;
import org.eclipse.linuxtools.systemtap.structures.IFormattingStyles;
import org.eclipse.linuxtools.systemtap.structures.StringFormatter;
import org.eclipse.linuxtools.systemtap.structures.listeners.IUpdateListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class DataGrid
implements IUpdateListener {
    public static final int NONE = 0;
    public static final int FULL_UPDATE = 1;
    private IFilteredDataSet filteredDataSet;
    private IFormattingStyles[] columnFormat;
    private Table table;
    private Point clickLocation;
    private IPreferenceStore prefs = GraphingUIPlugin.getDefault().getPreferenceStore();
    private Menu filterMenu;
    private MenuItem autoResizeMenuItem;
    private MenuItem jumpToEntryMenuItem;
    private MenuItem removeFiltersMenuItem;
    private MenuItem formatMenuItem;
    private IPropertyChangeListener propertyChangeListener;

    public DataGrid(Composite composite, IFilteredDataSet set) {
        this.filteredDataSet = set;
        this.clickLocation = new Point(-1, -1);
        this.createPartControl(composite);
        this.propertyChangeListener = event -> {
            if (event.getProperty().equals("MaxDataItems")) {
                this.handleUpdateEvent();
            }
        };
        this.prefs.addPropertyChangeListener(this.propertyChangeListener);
    }

    public Control getControl() {
        return this.table;
    }

    private void createPartControl(Composite parent) {
        this.table = new Table(parent, 65540);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.getVerticalBar().setVisible(true);
        String[] names = this.filteredDataSet.getTitles();
        TableColumn column = new TableColumn(this.table, 16384);
        column.setText(Localization.getString("DataGrid.Row"));
        column.pack();
        column.setMoveable(false);
        column.setResizable(false);
        this.columnFormat = new IFormattingStyles[names.length];
        for (int i = 0; i < names.length; ++i) {
            column = new TableColumn(this.table, 16384);
            column.setText(names[i]);
            column.pack();
            column.setMoveable(true);
            this.columnFormat[i] = new StringFormatter();
        }
        this.table.setMenu(this.initMenus());
        this.table.addListener(3, event -> {
            this.clickLocation.x = event.x;
            this.clickLocation.y = event.y;
        });
        this.handleUpdateEvent();
    }

    private Menu initMenus() {
        Menu menu = new Menu((Decorations)this.table.getShell(), 8);
        Menu formatMenu = new Menu(menu);
        this.formatMenuItem = new MenuItem(menu, 64);
        this.formatMenuItem.setText(Localization.getString("DataGrid.FormatAs"));
        this.formatMenuItem.setMenu(formatMenu);
        this.filterMenu = new Menu(menu);
        MenuItem item = new MenuItem(menu, 64);
        item.setText(Localization.getString("DataGrid.AddFilter"));
        item.addSelectionListener((SelectionListener)new AddFilterSelection());
        this.removeFiltersMenuItem = new MenuItem(menu, 64);
        this.removeFiltersMenuItem.setText(Localization.getString("DataGrid.RemoveFilter"));
        this.removeFiltersMenuItem.setMenu(this.filterMenu);
        IDataSetFilter[] filters = this.filteredDataSet.getFilters();
        if (filters != null && filters.length > 0) {
            for (IDataSetFilter iDataSetFilter : filters) {
                item = new MenuItem(this.filterMenu, 64);
                item.setText(AvailableFilterTypes.getFilterName(iDataSetFilter.getID()));
                item.setData((Object)iDataSetFilter);
                item.addSelectionListener((SelectionListener)new RemoveFilterSelection());
            }
        } else {
            this.removeFiltersMenuItem.setEnabled(false);
        }
        this.autoResizeMenuItem = new MenuItem(menu, 32);
        this.autoResizeMenuItem.setText(Localization.getString("DataGrid.AutoResize"));
        this.autoResizeMenuItem.setSelection(this.prefs.getBoolean("AutoResizeColumns"));
        this.jumpToEntryMenuItem = new MenuItem(menu, 32);
        this.jumpToEntryMenuItem.setText(Localization.getString("DataGrid.JumpToEntry"));
        this.jumpToEntryMenuItem.setSelection(this.prefs.getBoolean("JumpNewTableEntry"));
        for (String string : IFormattingStyles.FORMAT_TITLES) {
            item = new MenuItem(formatMenu, 16);
            item.setText(string);
            item.addSelectionListener((SelectionListener)new MenuFormatSelection());
        }
        this.formatMenuItem.setEnabled(this.filteredDataSet.getRowCount() > 0);
        formatMenu.addMenuListener((MenuListener)new FormatMenuListener());
        return menu;
    }

    private int getSelectedColumn() {
        TableColumn[] cols = this.table.getColumns();
        int location = 0;
        for (int i = 0; i < cols.length; ++i) {
            if (this.clickLocation.x <= location || this.clickLocation.x >= (location += cols[i].getWidth())) continue;
            return i;
        }
        return cols.length - 1;
    }

    public void handleUpdateEvent() {
        if (this.table.isDisposed()) {
            return;
        }
        this.table.getDisplay().asyncExec(() -> {
            int startLocation;
            if (this.table.isDisposed()) {
                return;
            }
            int endLocation = this.filteredDataSet.getRowCount();
            int maxItems = this.prefs.getInt("MaxDataItems");
            int oldSelection = this.table.getSelectionIndex();
            this.table.removeAll();
            for (int i1 = startLocation = Math.max(endLocation - maxItems, 0); i1 < endLocation; ++i1) {
                TableItem item = new TableItem(this.table, 0);
                Object[] os = this.filteredDataSet.getRow(i1);
                item.setText(0, Integer.toString(i1 + 1));
                for (int j = 0; j < os.length; ++j) {
                    if (os[j] == null) continue;
                    item.setText(j + 1, this.columnFormat[j].format(os[j].toString()));
                }
            }
            if (oldSelection != -1) {
                this.table.select(oldSelection);
            }
            TableColumn col = this.table.getColumn(0);
            col.pack();
            if (this.autoResizeMenuItem.getSelection()) {
                TableColumn[] cols = this.table.getColumns();
                for (int i2 = 1; i2 < cols.length; ++i2) {
                    cols[i2].pack();
                }
            }
            if (this.jumpToEntryMenuItem.getSelection() && this.table.getItemCount() > 0) {
                this.table.getDisplay().asyncExec(() -> this.table.showItem(this.table.getItem(this.table.getItemCount() - 1)));
            }
            this.formatMenuItem.setEnabled(this.table.getItemCount() > 0);
        });
    }

    public void dispose() {
        this.filteredDataSet = null;
        this.table.dispose();
        this.table = null;
        this.clickLocation = null;
        this.columnFormat = null;
        this.prefs.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    private class AddFilterSelection
    extends SelectionAdapter {
        private AddFilterSelection() {
        }

        public void widgetSelected(SelectionEvent e) {
            SelectFilterWizard wizard = new SelectFilterWizard(DataGrid.this.filteredDataSet.getTitles());
            IWorkbench workbench = PlatformUI.getWorkbench();
            wizard.init(workbench, null);
            WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            dialog.create();
            int result = dialog.open();
            if (result != 1) {
                IDataSetFilter filter = wizard.getFilter();
                DataGrid.this.removeFiltersMenuItem.setEnabled(true);
                DataGrid.this.filteredDataSet.addFilter(filter);
                DataGrid.this.table.removeAll();
                DataGrid.this.handleUpdateEvent();
                MenuItem item = new MenuItem(DataGrid.this.filterMenu, 64);
                item.setText(MessageFormat.format(Localization.getString("DataGrid.FilterLabel"), AvailableFilterTypes.getFilterName(filter.getID()), DataGrid.this.filteredDataSet.getTitles()[filter.getColumn()], filter.getInfo()));
                item.setData((Object)filter);
                item.addSelectionListener((SelectionListener)new RemoveFilterSelection());
            }
            wizard.dispose();
        }
    }

    private class RemoveFilterSelection
    implements SelectionListener {
        private RemoveFilterSelection() {
        }

        public void widgetSelected(SelectionEvent e) {
            IDataSetFilter idsf = (IDataSetFilter)e.widget.getData();
            e.widget.dispose();
            if (DataGrid.this.filterMenu.getItemCount() == 0) {
                DataGrid.this.removeFiltersMenuItem.setEnabled(false);
            }
            if (DataGrid.this.filteredDataSet.removeFilter(idsf)) {
                DataGrid.this.table.removeAll();
                DataGrid.this.handleUpdateEvent();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class MenuFormatSelection
    extends SelectionAdapter {
        private MenuFormatSelection() {
        }

        public void widgetSelected(SelectionEvent e) {
            int i;
            int format = 0;
            int column = Math.max(1, DataGrid.this.getSelectedColumn());
            for (i = 0; i < IFormattingStyles.FORMAT_TITLES.length; ++i) {
                if (!IFormattingStyles.FORMAT_TITLES[i].equals(((MenuItem)e.getSource()).getText())) continue;
                format = i;
            }
            Object[] data = DataGrid.this.filteredDataSet.getColumn(column - 1);
            DataGrid.this.columnFormat[column - 1].setFormat(format);
            for (i = 0; i < DataGrid.this.table.getItemCount(); ++i) {
                DataGrid.this.table.getItem(i).setText(column, DataGrid.this.columnFormat[column - 1].format(data[i].toString()));
            }
            DataGrid.this.table.redraw();
        }
    }

    private class FormatMenuListener
    extends MenuAdapter {
        private FormatMenuListener() {
        }

        public void menuShown(MenuEvent e) {
            MenuItem[] items = ((Menu)e.widget).getItems();
            boolean doubleValid = false;
            boolean longValid = false;
            int selectedCol = Math.max(1, DataGrid.this.getSelectedColumn());
            for (MenuItem item : items) {
                item.setSelection(false);
            }
            items[DataGrid.this.columnFormat[selectedCol - 1].getFormat()].setSelection(true);
            items[0].setEnabled(true);
            items[1].setEnabled(true);
            String itemText = DataGrid.this.filteredDataSet.getRow(0)[selectedCol - 1].toString();
            try {
                Double.parseDouble(itemText);
                doubleValid = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                Long.parseLong(itemText);
                longValid = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            items[3].setEnabled(doubleValid);
            items[4].setEnabled(longValid);
            items[5].setEnabled(longValid);
            items[6].setEnabled(longValid);
            items[2].setEnabled(longValid);
        }
    }
}

