/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.engine.python.ui.handlers;

import java.io.File;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Evaluate;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

import jakarta.inject.Named;

/**
 * <b>Warning</b> : As explained in
 * <a href="http://wiki.eclipse.org/Eclipse4/RCP/FAQ#Why_aren.27t_my_handler_fields_being_re-injected.3F">this wiki
 * page</a>, it is not recommended to define @Inject fields in a handler. <br/>
 * <br/>
 * <b>Inject the values in the @Execute methods</b>
 */
public class ExecutionEngineGeneratorHandler {
    @Evaluate
    @CanExecute
    public boolean canExecute(@Named(IServiceConstants.ACTIVE_SELECTION) @Optional IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        return selection.getFirstElement() instanceof IFile file ? "dispatching".equals(file.getFileExtension()) : false;
    }

    @Execute
    public void execute(@Named(IServiceConstants.ACTIVE_SELECTION) IStructuredSelection selection,
            @Named(IServiceConstants.ACTIVE_SHELL) Shell shell)
    {
        if (!PlatformUI.getWorkbench().saveAllEditors(true)) {
            return;
        }

        ExecutionEngineGeneratorDialog inputDialog = new ExecutionEngineGeneratorDialog(shell);
        if (inputDialog.open() == Window.CANCEL) {
            return;
        }


        IFile modelIFile = (IFile) selection.getFirstElement();
        IFolder saveIFolder = modelIFile.getProject().getFolder("src-gen" );
        File saveFolder = saveIFolder.getLocation().toFile();
        ExecutionEngineGeneratorJob job = new ExecutionEngineGeneratorJob(modelIFile, saveFolder,
                inputDialog.isRemoveClaimAndReleases(), inputDialog.isSimulate());
        job.setUser(true);
        job.schedule();
    }
}
