/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.profiler.ui.profilingdatatable;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.m2m.atl.profiler.core.util.ProfilingModelUtils;
import org.eclipse.m2m.atl.profiler.model.ATLOperation;
import org.eclipse.m2m.atl.profiler.model.ProfilingOperation;
import org.eclipse.m2m.atl.profiler.ui.profilingdatatable.ProfilingDataTableView;
import org.eclipse.swt.graphics.Image;

public class ProfilingDataTableLabelProvider
extends AdapterFactoryLabelProvider
implements ITableLabelProvider {
    public ProfilingDataTableLabelProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public String getColumnText(Object element, int columnIndex) {
        String txt = "";
        NumberFormat percentInstance = DecimalFormat.getPercentInstance();
        percentInstance.setMaximumFractionDigits(2);
        if (element instanceof ATLOperation) {
            ATLOperation atlOp = (ATLOperation)element;
            if (columnIndex == ProfilingDataTableView.getOperationNameId()) {
                txt = atlOp.getName();
            } else if (columnIndex == ProfilingDataTableView.getCallsId()) {
                txt = "" + atlOp.getCalls();
            } else if (columnIndex == ProfilingDataTableView.getTotalTimeExecutionId()) {
                if (ProfilingDataTableView.isShowPercentAction()) {
                    double pTime = ProfilingModelUtils.getTotalTime((EList)atlOp.getProfilingInstructions()) / ProfilingDataTableView.getTotalTime();
                    txt = percentInstance.format(pTime);
                } else {
                    txt = "" + ProfilingModelUtils.getTotalTime((EList)atlOp.getProfilingInstructions());
                }
            } else if (columnIndex == ProfilingDataTableView.getTotalInstructionsId()) {
                if (ProfilingDataTableView.isShowPercentAction()) {
                    double pInstr = (double)ProfilingModelUtils.getTotalInstruction((ATLOperation)atlOp) / (double)ProfilingDataTableView.getTotalInstructions();
                    txt = percentInstance.format(pInstr);
                } else {
                    txt = "" + ProfilingModelUtils.getTotalInstruction((ATLOperation)atlOp);
                }
            } else if (columnIndex == ProfilingDataTableView.getMaxMemoryColID()) {
                long maxMaxMem = ProfilingModelUtils.getMaxMaxMemoryUsage((ATLOperation)atlOp);
                txt = String.valueOf(this.convertMemToKb(maxMaxMem)) + " Kb";
            } else if (columnIndex == ProfilingDataTableView.getOutMemoryColId()) {
                long maxEndMem = ProfilingModelUtils.getMaxOutMemoryUsage((ATLOperation)atlOp);
                txt = String.valueOf(this.convertMemToKb(maxEndMem)) + " Kb";
            } else if (columnIndex == ProfilingDataTableView.getInMemoryColId()) {
                long minStartMem = ProfilingModelUtils.getMinInMemoryUsage((ATLOperation)atlOp);
                txt = String.valueOf(this.convertMemToKb(minStartMem)) + " Kb";
            } else {
                txt = "";
            }
        } else if (element instanceof ProfilingOperation) {
            ProfilingOperation pOp = (ProfilingOperation)element;
            Double time = new Double((double)(pOp.getEndTime() - pOp.getLaunchedTime()) / 1000.0);
            if (columnIndex == ProfilingDataTableView.getOperationNameId()) {
                txt = "[" + pOp.getInstructionID() + "] " + pOp.getContent();
            } else if (columnIndex == ProfilingDataTableView.getTotalTimeExecutionId()) {
                if (ProfilingDataTableView.isShowPercentAction()) {
                    double pTime = time / ProfilingDataTableView.getTotalTime();
                    txt = percentInstance.format(pTime);
                } else {
                    txt = "" + time;
                }
            } else if (columnIndex == ProfilingDataTableView.getTotalInstructionsId()) {
                if (ProfilingDataTableView.isShowPercentAction()) {
                    double pInstr = (double)pOp.getTotalExecutedInstructions() / (double)ProfilingDataTableView.getTotalInstructions();
                    txt = percentInstance.format(pInstr);
                } else {
                    txt = "" + pOp.getTotalExecutedInstructions();
                }
            } else if (columnIndex == ProfilingDataTableView.getInMemoryColId()) {
                long startMem = pOp.getLaunchedMemoryUsage() / 1000L;
                txt = String.valueOf(startMem) + " Kb";
            } else if (columnIndex == ProfilingDataTableView.getMaxMemoryColID()) {
                long avMem = pOp.getMaxMemoryUsage() / 1000L;
                txt = String.valueOf(avMem) + " Kb";
            } else if (columnIndex == ProfilingDataTableView.getOutMemoryColId()) {
                long exitMem = pOp.getEndMemoryUsage() / 1000L;
                txt = String.valueOf(exitMem) + " Kb";
            } else {
                txt = "";
            }
        }
        return txt;
    }

    private long convertMemToKb(long minStartMem) {
        return minStartMem / 1000L;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image img = null;
        if (element instanceof ATLOperation && columnIndex == 0 || element instanceof ProfilingOperation && columnIndex == 0) {
            return super.getColumnImage(element, columnIndex);
        }
        return img;
    }
}

