/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTiVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.AddStatement;
import org.eclipse.qvtd.pivot.qvtimperative.AppendParameter;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionVariable;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameter;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeHelper;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class AbstractRegion2Mapping {
    protected final @NonNull QVTs2QVTiVisitor visitor;
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull EnvironmentFactory environmentFactory;
    protected final @NonNull QVTimperativeHelper helper;
    protected final @NonNull Region region;
    private final @NonNull String regionName;
    protected final @NonNull Mapping mapping;
    private final @NonNull String mappingName;
    private final @NonNull Map<@NonNull Element, @NonNull Node> element2node = new HashMap<Element, Node>();
    private final @NonNull Map<@NonNull Node, @NonNull String> node2name = new HashMap<Node, String>();
    private final @NonNull Set<@NonNull String> names;
    protected Map<@NonNull NodeConnection, @NonNull ConnectionVariable> connection2variable = null;

    public AbstractRegion2Mapping(@NonNull QVTs2QVTiVisitor visitor, @NonNull Region region) {
        this.visitor = visitor;
        this.scheduleManager = visitor.getScheduleManager();
        this.environmentFactory = this.scheduleManager.getEnvironmentFactory();
        this.helper = new QVTimperativeHelper(this.environmentFactory);
        this.region = region;
        this.regionName = QVTscheduleUtil.getName((Nameable)region);
        String mappingName = region.getSymbolName();
        assert (mappingName != null);
        this.mapping = this.helper.createMapping(mappingName);
        this.mappingName = mappingName;
        if (region instanceof RuleRegion) {
            this.mapping.setIsAbstract(((RuleRegion)region).getReferredRule().isIsAbstract());
        }
        this.names = new HashSet<String>(visitor.getReservedNames());
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)region)) {
            for (Element element : node.getOriginatingElements()) {
                Node oldNode = this.element2node.put(element, node);
                assert (oldNode == null || oldNode == node);
            }
        }
    }

    protected void createAddStatement(@NonNull ConnectionVariable connectionVariable, @NonNull OCLExpression childrenExpression) {
        AddStatement addStatement = this.helper.createAddStatement(connectionVariable, childrenExpression);
        this.mapping.getOwnedStatements().add((Object)addStatement);
    }

    protected @NonNull AppendParameter createAppendParameter(@NonNull NodeConnection connection) {
        Type asType = this.getConnectionSourcesType(connection);
        String name = connection.getName();
        assert (name != null);
        return this.helper.createAppendParameter(this.getSafeName(name), asType, true);
    }

    protected @NonNull CallExp createCallExp(@NonNull OCLExpression asSource, @NonNull Property asProperty) {
        if (asProperty.eContainer() == null) {
            Type asType = asProperty.getType();
            if (asProperty == this.scheduleManager.getStandardLibraryHelper().getOclContainerProperty()) {
                return this.helper.createOperationCallExp(asSource, "oclContainer", new OCLExpression[0]);
            }
            if (asType != null && asProperty == this.scheduleManager.getCastProperty(asType)) {
                return this.createOclAsTypeCallExp(asSource, asType);
            }
            throw new UnsupportedOperationException();
        }
        NavigationCallExp asNavigationCallExp = this.helper.createNavigationCallExp(asSource, asProperty);
        if (!asSource.isIsRequired()) {
            asNavigationCallExp.setIsSafe(true);
            asNavigationCallExp.setIsRequired(false);
        }
        return asNavigationCallExp;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void createAppendParameters() {
        @NonNull List intermediateConnections = this.region.getIntermediateConnections();
        if (intermediateConnections.size() > 0) {
            this.connection2variable = new HashMap<NodeConnection, ConnectionVariable>();
            for (NodeConnection connection : intermediateConnections) {
                AppendParameter connectionVariable = this.createAppendParameter(connection);
                this.connection2variable.put(connection, (ConnectionVariable)connectionVariable);
                this.mapping.getOwnedMappingParameters().add((Object)connectionVariable);
            }
        }
    }

    public @NonNull MappingCall createMappingCall(@NonNull List<@NonNull MappingParameterBinding> mappingParameterBindings) {
        return this.helper.createMappingCall(this.getMapping(), mappingParameterBindings);
    }

    protected @NonNull CallExp createOclAsTypeCallExp(@NonNull OCLExpression asSource, @NonNull Type asType) {
        CompleteClass completeClass = this.environmentFactory.getCompleteModel().getCompleteClass(asType);
        TypeExp asTypeExp = this.helper.createTypeExp((Type)completeClass.getPrimaryClass());
        return this.helper.createOperationCallExp(asSource, "oclAsType", new OCLExpression[]{asTypeExp});
    }

    protected int getCollectionDepth(@NonNull Type type) {
        if (type instanceof CollectionType) {
            Type elementType = ((CollectionType)type).getElementType();
            assert (elementType != null);
            return this.getCollectionDepth(elementType) + 1;
        }
        return 0;
    }

    protected @NonNull Type getConnectionSourcesType(@NonNull NodeConnection connection) {
        IdResolver idResolver = this.environmentFactory.getIdResolver();
        Type asType = connection.getSourcesType(idResolver);
        assert (asType != null);
        return asType;
    }

    public @NonNull ConnectionVariable getConnectionVariable(@NonNull NodeConnection connection) {
        assert (this.connection2variable != null);
        ConnectionVariable connectionVariable = this.connection2variable.get(connection);
        assert (connectionVariable != null);
        return connectionVariable;
    }

    public abstract @NonNull List<@NonNull Node> getGuardNodes();

    public abstract @NonNull MappingParameter getGuardVariable(@NonNull Node var1);

    public @NonNull Mapping getMapping() {
        return this.mapping;
    }

    protected @NonNull MetamodelManager getMetamodelManager() {
        return this.visitor.getMetamodelManager();
    }

    public @Nullable Node getNode(@Nullable Element qvtmElement) {
        OppositePropertyCallExp propertyCallExp;
        Node sourceNode;
        if (qvtmElement instanceof VariableExp) {
            return this.getNode((Element)((VariableExp)qvtmElement).getReferredVariable());
        }
        if (qvtmElement instanceof LetExp) {
            return this.getNode((Element)((LetExp)qvtmElement).getOwnedIn());
        }
        if (qvtmElement instanceof OppositePropertyCallExp && (sourceNode = this.getNode((Element)(propertyCallExp = (OppositePropertyCallExp)qvtmElement).getOwnedSource())) != null) {
            return sourceNode.getNavigableTarget((Property)ClassUtil.nonNullState((Object)propertyCallExp.getReferredProperty().getOpposite()));
        }
        if (qvtmElement instanceof PropertyCallExp && (sourceNode = this.getNode((Element)(propertyCallExp = (PropertyCallExp)qvtmElement).getOwnedSource())) != null) {
            return sourceNode.getNavigableTarget((Property)ClassUtil.nonNullState((Object)propertyCallExp.getReferredProperty()));
        }
        if (qvtmElement != null) {
            return this.element2node.get(qvtmElement);
        }
        return null;
    }

    protected @NonNull Operation getObjectsOfKindOperation() {
        StandardLibraryInternal standardLibrary = (StandardLibraryInternal)this.visitor.getStandardLibrary();
        Class modelType = standardLibrary.getLibraryType("Model");
        OperationId objectsOfKindOperationId = modelType.getTypeId().getOperationId(1, "objectsOfKind", IdManager.getParametersId((TypeId[])new TypeId[]{TypeId.T_1}));
        Operation objectsOfKindOperation = this.environmentFactory.getIdResolver().getOperation(objectsOfKindOperationId);
        return objectsOfKindOperation;
    }

    protected @NonNull Operation getOclIsKindOfOperation() {
        AnyType oclAnyType = ((StandardLibraryInternal)this.visitor.getStandardLibrary()).getOclAnyType();
        Operation oclIsKindOfOperation = (Operation)NameUtil.getNameable((Iterable)oclAnyType.getOwnedOperations(), (String)"oclIsKindOf");
        assert (oclIsKindOfOperation != null);
        return oclIsKindOfOperation;
    }

    public @NonNull Region getRegion() {
        return this.region;
    }

    protected @NonNull Operation getRootObjectsOperation() {
        StandardLibraryInternal standardLibrary = (StandardLibraryInternal)this.visitor.getStandardLibrary();
        Class modelType = standardLibrary.getLibraryType("Model");
        OperationId rootObjectsOperationId = modelType.getTypeId().getOperationId(1, "rootObjects", IdManager.getParametersId((TypeId[])new TypeId[0]));
        Operation rootObjectsOperation = this.environmentFactory.getIdResolver().getOperation(rootObjectsOperationId);
        return rootObjectsOperation;
    }

    protected @NonNull String getSafeName(@NonNull Node node) {
        String name = this.node2name.get(node);
        if (name == null) {
            name = this.getSafeName(QVTscheduleUtil.getName((Nameable)node));
        }
        return name;
    }

    protected @NonNull String getSafeName(@NonNull String rawName) {
        String stem;
        String name = stem = rawName;
        assert (name != null);
        int suffix = 1;
        while (this.names.contains(name)) {
            name = String.valueOf(stem) + suffix++;
        }
        this.names.add(name);
        return name;
    }

    protected @NonNull Operation getSelectByKindOperation() {
        CollectionType collectionType = ((StandardLibraryInternal)this.visitor.getStandardLibrary()).getCollectionType();
        Operation selectByKindOperation = (Operation)NameUtil.getNameable((Iterable)collectionType.getOwnedOperations(), (String)"selectByKind");
        assert (selectByKindOperation != null);
        return selectByKindOperation;
    }

    public boolean isInfinite() {
        return false;
    }

    public abstract void synthesizeCallStatements();

    public abstract void synthesizeLocalStatements();

    public String toString() {
        return this.mapping.toString();
    }
}

