/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards.project;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.project.nature.NatureUtils;
import org.eclipse.m2m.internal.qvt.oml.ui.IStatusChangeListener;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.Messages;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.SourceContainerConfigBlock;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.Util;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class QvtSettingsPropertyPage
extends PropertyPage {
    private IProject fProject;
    private SourceContainerConfigBlock fSrcContainerBlock;

    protected Control createContents(Composite parent) {
        Control control = null;
        this.fProject = this.getSelectedProject();
        if (this.fProject != null && QvtSettingsPropertyPage.isQvtProject(this.fProject)) {
            this.fSrcContainerBlock = new SourceContainerConfigBlock(this.getShell(), this.fProject, this.createStatusListener());
            control = this.fSrcContainerBlock.createContents(parent);
        } else {
            control = this.createClosedControl(parent);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "org.eclipse.m2m.qvt.oml.transformation_project");
        return control;
    }

    public boolean performOk() {
        this.performApply();
        return this.isValid();
    }

    protected void performApply() {
        if (this.fSrcContainerBlock != null) {
            this.fSrcContainerBlock.performApply();
        }
    }

    protected void performDefaults() {
        if (this.fSrcContainerBlock != null) {
            this.fSrcContainerBlock.performDefaults();
        }
    }

    private IStatusChangeListener createStatusListener() {
        return new IStatusChangeListener(){

            @Override
            public void statusChanged(IStatus status) {
                QvtSettingsPropertyPage.this.setMessage(null);
                QvtSettingsPropertyPage.this.setErrorMessage(null);
                QvtSettingsPropertyPage.this.setValid(QvtSettingsPropertyPage.this.fSrcContainerBlock != null ? QvtSettingsPropertyPage.this.fSrcContainerBlock.isValid() : false);
                if (!status.isOK()) {
                    QvtSettingsPropertyPage.this.setMessage(status.getMessage(), Util.getIMessageProviderSeverity(status));
                }
            }
        };
    }

    private Control createClosedControl(Composite parent) {
        Label closedProjectLabel = new Label(parent, 0);
        closedProjectLabel.setText(Messages.QvtSettingsPropertyPage_NoBuilder);
        return closedProjectLabel;
    }

    private IProject getSelectedProject() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            return QvtSettingsPropertyPage.isQvtProject(project) ? project : null;
        }
        if (element instanceof IAdaptable) {
            IAdaptable adaptable = element;
            return (IProject)adaptable.getAdapter(IProject.class);
        }
        return null;
    }

    private static boolean isQvtProject(IProject project) {
        try {
            return project.isOpen() && NatureUtils.isBuilderEnabled((IProject)project, (String)"org.eclipse.m2m.qvt.oml.project.QVTOBuilder");
        }
        catch (CoreException e) {
            Logger.getLogger().log(Logger.SEVERE, "Builder check failed", e);
            return false;
        }
    }
}

