/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.egit.internal.merge;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.emf.compare.egit.internal.merge.GitCachedResourceVariantTree;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantCache;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantTreeProvider;
import org.eclipse.emf.compare.egit.internal.storage.TreeParserResourceVariant;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.variants.IResourceVariantTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeWalkResourceVariantTreeProvider
implements GitResourceVariantTreeProvider {
    private final IResourceVariantTree baseTree;
    private final IResourceVariantTree oursTree;
    private final IResourceVariantTree theirsTree;
    private final Set<IResource> roots;
    private final Set<IResource> knownResources;
    private final LinkedHashMap<IPath, IProject> map = new LinkedHashMap();

    public TreeWalkResourceVariantTreeProvider(Repository repository, TreeWalk treeWalk, int baseIndex, int ourIndex, int theirIndex) throws IOException {
        AbstractTreeIterator[] initialTrees = new AbstractTreeIterator[treeWalk.getTreeCount()];
        int i = 0;
        while (i < treeWalk.getTreeCount()) {
            initialTrees[i] = treeWalk.getTree(i, AbstractTreeIterator.class);
            ++i;
        }
        GitResourceVariantCache baseCache = new GitResourceVariantCache();
        GitResourceVariantCache theirsCache = new GitResourceVariantCache();
        GitResourceVariantCache oursCache = new GitResourceVariantCache();
        while (treeWalk.next()) {
            int modeTheirs;
            int modeOurs;
            int modeBase = treeWalk.getRawMode(baseIndex);
            if (!this.hasSignificantDifference(modeBase, modeOurs = treeWalk.getRawMode(ourIndex), modeTheirs = treeWalk.getRawMode(theirIndex))) continue;
            CanonicalTreeParser base = (CanonicalTreeParser)treeWalk.getTree(baseIndex, CanonicalTreeParser.class);
            CanonicalTreeParser ours = (CanonicalTreeParser)treeWalk.getTree(ourIndex, CanonicalTreeParser.class);
            CanonicalTreeParser theirs = (CanonicalTreeParser)treeWalk.getTree(theirIndex, CanonicalTreeParser.class);
            int nonZeroMode = modeBase != 0 ? modeBase : (modeOurs != 0 ? modeOurs : modeTheirs);
            IResource resource = this.getResourceHandleForLocation(repository, treeWalk.getPathString(), FileMode.fromBits((int)nonZeroMode) == FileMode.TREE);
            if (resource != null) {
                IPath workspacePath = resource.getFullPath();
                if (modeBase != 0) {
                    baseCache.setVariant(resource, TreeParserResourceVariant.create(repository, base, workspacePath));
                }
                if (modeOurs != 0) {
                    oursCache.setVariant(resource, TreeParserResourceVariant.create(repository, ours, workspacePath));
                }
                if (modeTheirs != 0) {
                    theirsCache.setVariant(resource, TreeParserResourceVariant.create(repository, theirs, workspacePath));
                }
            }
            if (!treeWalk.isSubtree()) continue;
            treeWalk.enterSubtree();
        }
        treeWalk.reset();
        int i2 = 0;
        while (i2 < initialTrees.length) {
            initialTrees[i2].reset();
            treeWalk.addTree(initialTrees[i2]);
            ++i2;
        }
        this.baseTree = new GitCachedResourceVariantTree(baseCache);
        this.theirsTree = new GitCachedResourceVariantTree(theirsCache);
        this.oursTree = new GitCachedResourceVariantTree(oursCache);
        this.roots = new LinkedHashSet<IResource>();
        this.roots.addAll(baseCache.getRoots());
        this.roots.addAll(oursCache.getRoots());
        this.roots.addAll(theirsCache.getRoots());
        this.knownResources = new LinkedHashSet<IResource>();
        this.knownResources.addAll(baseCache.getKnownResources());
        this.knownResources.addAll(oursCache.getKnownResources());
        this.knownResources.addAll(theirsCache.getKnownResources());
    }

    private boolean hasSignificantDifference(int modeBase, int modeOurs, int modeTheirs) {
        if (modeBase == 0) {
            if (FileMode.fromBits((int)(modeOurs | modeTheirs)) != FileMode.MISSING) {
                return true;
            }
            return FileMode.fromBits((int)modeOurs) == FileMode.TREE && FileMode.fromBits((int)modeTheirs) != FileMode.TREE || FileMode.fromBits((int)modeOurs) != FileMode.TREE && FileMode.fromBits((int)modeTheirs) == FileMode.TREE;
        }
        return FileMode.fromBits((int)(modeBase & modeOurs)) != FileMode.MISSING || FileMode.fromBits((int)(modeBase & modeTheirs)) != FileMode.MISSING;
    }

    @Override
    public IResourceVariantTree getBaseTree() {
        return this.baseTree;
    }

    @Override
    public IResourceVariantTree getRemoteTree() {
        return this.theirsTree;
    }

    @Override
    public IResourceVariantTree getSourceTree() {
        return this.oursTree;
    }

    @Override
    public Set<IResource> getKnownResources() {
        return this.knownResources;
    }

    @Override
    public Set<IResource> getRoots() {
        return this.roots;
    }

    public IResource getResourceHandleForLocation(Repository repository, String repoRelativePath, boolean isFolder) {
        Object resource = null;
        String workDir = repository.getWorkTree().getAbsolutePath();
        Path path = new Path(String.valueOf(workDir) + '/' + repoRelativePath);
        File file = path.toFile();
        if (file.exists()) {
            resource = isFolder ? ResourceUtil.getContainerForLocation((IPath)path, (boolean)false) : ResourceUtil.getFileForLocation((IPath)path, (boolean)false);
        }
        if (repoRelativePath.endsWith(".project")) {
            IPath parentPath = path.removeLastSegments(1);
            IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(parentPath.lastSegment().toString());
            if (this.map.get(parentPath) == null) {
                this.map.put(parentPath, p);
            }
        }
        if (resource == null) {
            ArrayList<IPath> list = new ArrayList<IPath>(this.map.keySet());
            int i = list.size() - 1;
            while (i >= 0) {
                IPath projectPath = (IPath)list.get(i);
                if (projectPath.isPrefixOf((IPath)path) && !projectPath.equals((Object)path)) {
                    IPath projectRelativePath = path.makeRelativeTo(projectPath);
                    if (isFolder) {
                        resource = this.map.get(projectPath).getFolder(projectRelativePath);
                        break;
                    }
                    resource = this.map.get(projectPath).getFile(projectRelativePath);
                    break;
                }
                --i;
            }
        }
        if (resource == null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] iProjectArray = root.getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath projectLocation;
                IProject project = iProjectArray[n2];
                if (RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.egit.core.GitProvider") != null && (projectLocation = project.getLocation()) != null && projectLocation.isPrefixOf((IPath)path)) {
                    IPath projectRelativePath = path.makeRelativeTo(projectLocation);
                    if (isFolder) {
                        resource = project.getFolder(projectRelativePath);
                        break;
                    }
                    resource = project.getFile(projectRelativePath);
                    break;
                }
                ++n2;
            }
        }
        return resource;
    }
}

