/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.IModelUpdateStrategy;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.ChangeCommand;

public class SingleValuedAttributeModelUpdateStrategy
implements IModelUpdateStrategy {
    public boolean canUpdate(Diff diff, IMergeViewer.MergeViewerSide side) {
        return this.isSingleValuedAttributeChange(diff) && this.haveTargetObject(diff, side);
    }

    private boolean isSingleValuedAttributeChange(Diff diff) {
        return diff instanceof AttributeChange && !((AttributeChange)diff).getAttribute().isMany();
    }

    private boolean haveTargetObject(Diff diff, IMergeViewer.MergeViewerSide side) {
        return this.getTargetObject(diff, side) != null;
    }

    private EObject getTargetObject(Diff diff, IMergeViewer.MergeViewerSide side) {
        return MergeViewerUtil.getEObject(diff.getMatch(), side);
    }

    public Command getModelUpdateCommand(final Diff diff, final Object newValue, final IMergeViewer.MergeViewerSide side) {
        final EObject targetObject = this.getTargetObject(diff, side);
        return new ChangeCommand((Notifier)targetObject){

            public boolean canExecute() {
                return SingleValuedAttributeModelUpdateStrategy.this.canUpdate(diff, side) && SingleValuedAttributeModelUpdateStrategy.this.needsUpdate(diff, newValue, side) && super.canExecute();
            }

            protected void doExecute() {
                EAttribute eAttribute = ((AttributeChange)diff).getAttribute();
                targetObject.eSet((EStructuralFeature)eAttribute, newValue);
            }
        };
    }

    private boolean needsUpdate(Diff diff, Object newValue, IMergeViewer.MergeViewerSide side) {
        EAttribute eAttribute;
        EObject eObject;
        String oldValue;
        IEqualityHelper equalityHelper = ComparisonUtil.getComparison((Diff)diff).getEqualityHelper();
        return !equalityHelper.matchingAttributeValues(newValue, (Object)(oldValue = this.getStringValue(eObject = this.getTargetObject(diff, side), eAttribute = ((AttributeChange)diff).getAttribute())));
    }

    private String getStringValue(EObject eObject, EAttribute eAttribute) {
        EDataType eAttributeType = eAttribute.getEAttributeType();
        Object value = eObject == null ? null : ReferenceUtil.safeEGet((EObject)eObject, (EStructuralFeature)eAttribute);
        return EcoreUtil.convertToString((EDataType)eAttributeType, (Object)value);
    }
}

