/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.papyrus.contentmergeviewer;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.contentmergeviewer.provider.PapyrusTreeContentMergeViewerItemContentProvider;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.contentmergeviewer.provider.PapyrusTreeContentMergeViewerItemLabelProvider;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.TreeContentMergeViewer;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.ICompareAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.AbstractMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.AbstractTableOrTreeMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.TreeMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;

public class PapyrusTreeContentMergeViewer
extends TreeContentMergeViewer {
    private static final int MAX_SEARCH_LEVEL = 20;
    private Map<Object, IMergeViewerItem> cachedMapForSelection;

    public PapyrusTreeContentMergeViewer(int style, ResourceBundle bundle, Composite parent, EMFCompareConfiguration config) {
        super(style, bundle, parent, config);
    }

    protected AbstractMergeViewer createMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side) {
        TreeMergeViewer mergeTreeViewer = new TreeMergeViewer(parent, side, (ICompareColor.Provider)this, (IEMFCompareConfiguration)this.getCompareConfiguration());
        PapyrusTreeContentMergeViewerItemContentProvider contentProvider = new PapyrusTreeContentMergeViewerItemContentProvider((AdapterFactory)this.getAdapterFactory(), this.getCompareConfiguration(), this.getDifferenceGroupProvider(), (Predicate<? super EObject>)this.getDifferenceFilterPredicate());
        mergeTreeViewer.setContentProvider((IContentProvider)contentProvider);
        PapyrusTreeContentMergeViewerItemLabelProvider labelProvider = new PapyrusTreeContentMergeViewerItemLabelProvider(this.getResourceBundle(), (AdapterFactory)this.getAdapterFactory(), side);
        mergeTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.hookListeners(mergeTreeViewer);
        return mergeTreeViewer;
    }

    private static boolean isCompareAccessor(Object input) {
        return input instanceof ICompareAccessor;
    }

    private boolean isDifferentInput(IMergeViewer.MergeViewerSide side, Object input) {
        TreeMergeViewer viewer = this.getMergeViewer(side);
        if (!PapyrusTreeContentMergeViewer.isCompareAccessor(input) || !PapyrusTreeContentMergeViewer.isCompareAccessor(viewer.getInput())) {
            return true;
        }
        ImmutableList inputItems = ((ICompareAccessor)ICompareAccessor.class.cast(input)).getItems();
        ImmutableList vieweritems = ((ICompareAccessor)ICompareAccessor.class.cast(viewer.getInput())).getItems();
        if (inputItems.size() != vieweritems.size()) {
            return true;
        }
        AbstractTableOrTreeMergeViewer.ElementComparer comparer = new AbstractTableOrTreeMergeViewer.ElementComparer();
        int i = 0;
        while (i < vieweritems.size()) {
            if (!comparer.equals(inputItems.get(i), vieweritems.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public TreeMergeViewer getMergeViewer(IMergeViewer.MergeViewerSide side) {
        if (side == IMergeViewer.MergeViewerSide.LEFT) {
            return this.getLeftMergeViewer();
        }
        if (side == IMergeViewer.MergeViewerSide.RIGHT) {
            return this.getRightMergeViewer();
        }
        return this.getAncestorMergeViewer();
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        if (this.isDifferentInput(IMergeViewer.MergeViewerSide.LEFT, left) || this.isDifferentInput(IMergeViewer.MergeViewerSide.RIGHT, right)) {
            this.getAncestorMergeViewer().setInput(ancestor);
            this.getLeftMergeViewer().setInput(left);
            this.getRightMergeViewer().setInput(right);
        }
        IMergeViewerItem leftInitialItem = null;
        if (left instanceof ICompareAccessor) {
            leftInitialItem = ((ICompareAccessor)left).getInitialItem();
        }
        if (leftInitialItem == null || leftInitialItem.getLeft() == null) {
            if (right instanceof ICompareAccessor) {
                IMergeViewerItem rightInitialItem = ((ICompareAccessor)right).getInitialItem();
                if (rightInitialItem == null) {
                    this.getLeftMergeViewer().setSelection((ISelection)StructuredSelection.EMPTY, true);
                } else {
                    this.setSelection((ICompareAccessor)right, this.getRightMergeViewer());
                }
            } else {
                this.getLeftMergeViewer().setSelection((ISelection)StructuredSelection.EMPTY, true);
            }
        } else {
            this.setSelection((ICompareAccessor)left, this.getLeftMergeViewer());
        }
        this.redrawCenterControl();
    }

    private void cacheTreeViewerContentIfNecessary(Object left, Object right) {
        if (this.cachedMapForSelection != null || this.notICompareAccessor(left, right)) {
            return;
        }
        this.cachedMapForSelection = new HashMap<Object, IMergeViewerItem>();
        this.cacheTreeViewerContent((ICompareAccessor)left, this.getLeftMergeViewer(), IMergeViewer.MergeViewerSide.LEFT);
        this.cacheTreeViewerContent((ICompareAccessor)right, this.getRightMergeViewer(), IMergeViewer.MergeViewerSide.RIGHT);
    }

    private boolean notICompareAccessor(Object ... objects) {
        return Iterables.any(Arrays.asList(objects), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(ICompareAccessor.class)));
    }

    private void cacheTreeViewerContent(ICompareAccessor accessor, TreeMergeViewer viewer, IMergeViewer.MergeViewerSide side) {
        ITreeContentProvider provider = (ITreeContentProvider)ITreeContentProvider.class.cast(viewer.getContentProvider());
        Object[] objectArray = provider.getElements((Object)accessor);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IMergeViewerItem) {
                IMergeViewerItem item = (IMergeViewerItem)IMergeViewerItem.class.cast(element);
                this.cacheTreeViewerContent(item, provider, side, 20);
            }
            ++n2;
        }
    }

    private void cacheTreeViewerContent(IMergeViewerItem item, ITreeContentProvider provider, IMergeViewer.MergeViewerSide side, int maxSearchLevel) {
        if (maxSearchLevel == 0) {
            return;
        }
        this.cacheItem(item, side);
        Object[] objectArray = provider.getChildren((Object)item);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof IMergeViewerItem) {
                IMergeViewerItem childItem = (IMergeViewerItem)child;
                this.cacheTreeViewerContent(childItem, provider, side, maxSearchLevel - 1);
            }
            ++n2;
        }
    }

    private void cacheItem(IMergeViewerItem item, IMergeViewer.MergeViewerSide side) {
        if (IMergeViewer.MergeViewerSide.LEFT.equals((Object)side) && item.getLeft() != null) {
            this.cachedMapForSelection.put(item.getLeft(), item);
        } else if (IMergeViewer.MergeViewerSide.RIGHT.equals((Object)side) && item.getRight() != null) {
            this.cachedMapForSelection.put(item.getRight(), item);
        }
    }

    private void setSelection(ICompareAccessor accessor, TreeMergeViewer viewer) {
        IMergeViewerItem initialItem = accessor.getInitialItem();
        viewer.setSelection((ISelection)new StructuredSelection((Object)initialItem), true);
        if (viewer.getSelection().isEmpty()) {
            this.cacheTreeViewerContentIfNecessary(this.getLeftMergeViewer().getInput(), this.getRightMergeViewer().getInput());
            IMergeViewerItem itemToBeSelected = this.getItemToBeSelectedFromCache(initialItem);
            if (itemToBeSelected != null) {
                viewer.setSelection((ISelection)new StructuredSelection((Object)itemToBeSelected), true);
            } else {
                viewer.setSelection((ISelection)new StructuredSelection(), true);
            }
        }
    }

    private IMergeViewerItem getItemToBeSelectedFromCache(IMergeViewerItem item) {
        IMergeViewerItem itemToBeSelected = null;
        if (IMergeViewer.MergeViewerSide.LEFT.equals((Object)item.getSide()) && item.getLeft() != null) {
            itemToBeSelected = this.cachedMapForSelection.get(item.getLeft());
        } else if (IMergeViewer.MergeViewerSide.RIGHT.equals((Object)item.getSide()) && item.getRight() != null) {
            itemToBeSelected = this.cachedMapForSelection.get(item.getRight());
        }
        return itemToBeSelected;
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.cachedMapForSelection != null) {
            this.cachedMapForSelection.clear();
            this.cachedMapForSelection = null;
        }
        super.handleDispose(event);
    }
}

