/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.workspace;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class TestProject {
    private File workspaceSupplement;
    private String location;
    private IProject project;

    public TestProject() throws CoreException {
        this("Project-1");
    }

    public TestProject(String path) throws CoreException {
        this(path, true, null);
    }

    public TestProject(String path, boolean delete, File workspaceSupplement) throws CoreException {
        IPath locationBefore;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.workspaceSupplement = workspaceSupplement;
        IProjectDescription description = this.createDescription(path, true, root, workspaceSupplement);
        this.project = root.getProject(description.getName());
        if (delete) {
            this.project.delete(true, true, null);
        }
        if ((locationBefore = description.getLocation()) == null) {
            locationBefore = root.getRawLocation().append(path);
        }
        this.location = locationBefore.toOSString();
        this.project.create(description, null);
        this.project.open(null);
    }

    private IProjectDescription createDescription(String path, boolean insidews, IWorkspaceRoot root, File workspaceSupplement) {
        Path ppath = new Path(path);
        String projectName = ppath.lastSegment();
        URI top = insidews ? root.getRawLocationURI() : URIUtil.toURI((String)workspaceSupplement.getAbsolutePath());
        URI locationURI = !insidews || !ppath.lastSegment().equals(path) ? URIUtil.toURI((IPath)URIUtil.toPath((URI)top).append(path)) : null;
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        description.setName(projectName);
        description.setLocationURI(locationURI);
        return description;
    }

    public TestProject(String name, String location) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(name);
        description.setLocation((IPath)new Path(String.valueOf(location) + File.separator + name));
        this.project = root.getProject(description.getName());
        if (this.project.exists()) {
            this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        this.project.create(description, (IProgressMonitor)new NullProgressMonitor());
        this.project.open((IProgressMonitor)new NullProgressMonitor());
    }

    public IProject getProject() {
        return this.project;
    }

    public File getOrCreateFile(IProject aProject, String path) throws IOException {
        String fullPath = aProject.getLocation().append(path).toOSString();
        int lastSeparator = fullPath.lastIndexOf(File.separator);
        TestProject.mkdirs(new File(fullPath.substring(0, lastSeparator)), true);
        File file = new File(fullPath);
        if (!file.exists()) {
            TestProject.createNewFile(file);
        }
        return file;
    }

    public IFile getIFile(IProject aProject, File file) throws CoreException {
        Path filePath = new Path(file.getAbsolutePath());
        String relativePath = filePath.makeRelativeTo(aProject.getLocation()).toString();
        String quotedProjectName = Pattern.quote(aProject.getName());
        relativePath = relativePath.replaceFirst(quotedProjectName, "");
        IFile iFile = aProject.getFile(relativePath);
        iFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        return iFile;
    }

    private static void mkdirs(File d, boolean skipExisting) throws IOException {
        if (!d.mkdirs()) {
            if (skipExisting && d.isDirectory()) {
                return;
            }
            throw new IOException();
        }
    }

    private static void createNewFile(File f) throws IOException {
        f.createNewFile();
    }

    public IFile createFile(String name, InputStream inputStream) throws Exception {
        IFile file = this.project.getFile(name);
        if (!file.getParent().exists()) {
            ((IFolder)file.getParent()).create(1, true, (IProgressMonitor)new NullProgressMonitor());
        }
        file.create(inputStream, true, (IProgressMonitor)new NullProgressMonitor());
        return file;
    }

    public IFile createFile(String name, byte[] content) throws Exception {
        return this.createFile(name, new ByteArrayInputStream(content));
    }

    public IFolder createFolder(String name) throws Exception {
        IFolder folder = this.project.getFolder(name);
        folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        return folder;
    }

    public void dispose() throws CoreException, IOException {
        if (this.project.exists()) {
            this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

