/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.preferences;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public class LoggingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo levelCombo;
    private Text fileField;
    private Text maxSizeField;
    private Text maxBackupField;
    private final String[] LOG_LEVELS = new String[]{"OFF", "ERROR", "INFO", "DEBUG"};

    public LoggingPreferencePage() {
    }

    public LoggingPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public LoggingPreferencePage(String title) {
        super(title);
    }

    public void init(IWorkbench workbench) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.emf.compare.rcp");
        store.setSearchContexts(new IScopeContext[]{InstanceScope.INSTANCE, ConfigurationScope.INSTANCE});
        this.setPreferenceStore((IPreferenceStore)store);
    }

    protected Control createContents(Composite parent) {
        Composite loggingComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(loggingComposite);
        new Label(loggingComposite, 16384).setText(EMFCompareRCPUIMessages.getString("LoggingPreferencePage.log.level"));
        this.levelCombo = new Combo(loggingComposite, 4);
        this.levelCombo.setItems(this.LOG_LEVELS);
        this.levelCombo.setLayoutData((Object)this.getDefaultFieldGridData(100));
        Label fileLabel = new Label(loggingComposite, 16384);
        fileLabel.setText(EMFCompareRCPUIMessages.getString("LoggingPreferencePage.log.file"));
        this.fileField = new Text(loggingComposite, 2052);
        this.fileField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button fileButton = new Button(loggingComposite, 8);
        fileButton.setText(EMFCompareRCPUIMessages.getString("LoggingPreferencePage.filebutton.label"));
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(LoggingPreferencePage.this.getShell(), 8192);
                File file = new File(LoggingPreferencePage.this.fileField.getText());
                dlg.setFileName(file.getName());
                dlg.setFilterPath(file.getParent());
                String fileName = dlg.open();
                if (fileName != null) {
                    LoggingPreferencePage.this.fileField.setText(fileName);
                }
            }
        });
        Label maxSizeLabel = new Label(loggingComposite, 16384);
        maxSizeLabel.setText(EMFCompareRCPUIMessages.getString("LoggingPreferencePage.log.file.size"));
        this.maxSizeField = new Text(loggingComposite, 2052);
        this.maxSizeField.setLayoutData((Object)this.getDefaultFieldGridData(80));
        this.maxSizeField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoggingPreferencePage.this.verifyIntegerFields();
            }
        });
        Label maxBackupLabel = new Label(loggingComposite, 16384);
        maxBackupLabel.setText(EMFCompareRCPUIMessages.getString("LoggingPreferencePage.log.backup.count"));
        this.maxBackupField = new Text(loggingComposite, 2052);
        this.maxBackupField.setLayoutData((Object)this.getDefaultFieldGridData(80));
        this.maxBackupField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoggingPreferencePage.this.verifyIntegerFields();
            }
        });
        this.refreshWidgets();
        return loggingComposite;
    }

    protected GridData getDefaultFieldGridData(int width) {
        GridData gd = new GridData(16384, 128, false, false, 2, 1);
        gd.widthHint = width;
        return gd;
    }

    protected void savePreferences() throws BackingStoreException, IOException {
        this.getPreferenceStore().setValue("org.eclipse.emf.compare.log.file.name", this.fileField.getText());
        String item = this.levelCombo.getItem(this.levelCombo.getSelectionIndex());
        this.getPreferenceStore().setValue("org.eclipse.emf.compare.log.level", item);
        this.getPreferenceStore().setValue("org.eclipse.emf.compare.log.backup.count", this.maxBackupField.getText());
        this.getPreferenceStore().setValue("org.eclipse.emf.compare.log.file.max.size", this.maxSizeField.getText());
    }

    protected void resetPreferences() {
        this.getPreferenceStore().setToDefault("org.eclipse.emf.compare.log.file.name");
        this.getPreferenceStore().setToDefault("org.eclipse.emf.compare.log.level");
        this.getPreferenceStore().setToDefault("org.eclipse.emf.compare.log.backup.count");
        this.getPreferenceStore().setToDefault("org.eclipse.emf.compare.log.file.max.size");
    }

    protected void refreshWidgets() {
        IPreferencesService prefsService = Platform.getPreferencesService();
        String fileName = prefsService.getString("org.eclipse.emf.compare.rcp", "org.eclipse.emf.compare.log.file.name", "", null);
        String level = prefsService.getString("org.eclipse.emf.compare.rcp", "org.eclipse.emf.compare.log.level", "OFF", null);
        int maxBackupCount = prefsService.getInt("org.eclipse.emf.compare.rcp", "org.eclipse.emf.compare.log.backup.count", 10, null);
        int maxSizeInMB = prefsService.getInt("org.eclipse.emf.compare.rcp", "org.eclipse.emf.compare.log.file.max.size", 100, null);
        this.levelCombo.select(Arrays.asList(this.LOG_LEVELS).indexOf(level));
        this.levelCombo.pack();
        this.fileField.setText(fileName);
        this.maxBackupField.setText(Integer.toString(maxBackupCount));
        this.maxSizeField.setText(Integer.toString(maxSizeInMB));
    }

    public boolean performOk() {
        try {
            this.savePreferences();
            this.refreshWidgets();
            return super.performOk();
        }
        catch (IOException | BackingStoreException e) {
            return false;
        }
    }

    protected void performDefaults() {
        this.resetPreferences();
        this.refreshWidgets();
        super.performDefaults();
    }

    private void verifyIntegerFields() {
        try {
            Integer.parseInt(this.maxSizeField.getText());
            Integer.parseInt(this.maxBackupField.getText());
            this.setPreferencePageError(true, null);
        }
        catch (Exception e) {
            this.setPreferencePageError(false, EMFCompareRCPUIMessages.getString("LoggingPreferencePage.error.message"));
        }
    }

    private void setPreferencePageError(boolean isValid, String errorMessage) {
        this.setValid(isValid);
        this.setErrorMessage(errorMessage);
    }
}

