/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.resource.CDOPathFeature;
import org.eclipse.emf.cdo.common.model.resource.CDOResourceClass;
import org.eclipse.emf.cdo.server.IPackageManager;
import org.eclipse.emf.cdo.server.db.IAttributeMapping;
import org.eclipse.emf.cdo.server.db.IClassMapping;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreReader;
import org.eclipse.emf.cdo.server.db.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.ClassServerInfo;
import org.eclipse.emf.cdo.server.internal.db.NoClassMapping;
import org.eclipse.emf.cdo.server.internal.db.ObjectIDIterator;
import org.eclipse.emf.cdo.server.internal.db.ToMany;
import org.eclipse.emf.cdo.server.internal.db.ToOne;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MappingStrategy
extends Lifecycle
implements IMappingStrategy {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, MappingStrategy.class);
    public static final String PROP_TO_MANY_REFERENCE_MAPPING = "toManyReferenceMapping";
    public static final String PROP_TO_ONE_REFERENCE_MAPPING = "toOneReferenceMapping";
    private IDBStore store;
    private Map<String, String> properties;
    private Map<Object, IDBTable> referenceTables = new HashMap<Object, IDBTable>();
    private Map<Integer, CDOClassRef> classRefs = new HashMap<Integer, CDOClassRef>();
    private IClassMapping resourceClassMapping;
    private IAttributeMapping resourcePathMapping;
    private IDBTable resourceTable;
    private IDBField resourceIDField;
    private IDBField resourcePathField;

    @Override
    public IDBStore getStore() {
        return this.store;
    }

    @Override
    public void setStore(IDBStore store) {
        this.store = store;
    }

    @Override
    public synchronized Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    @Override
    public synchronized void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public ToMany getToMany() {
        String value = this.getProperties().get(PROP_TO_MANY_REFERENCE_MAPPING);
        return value == null ? ToMany.PER_REFERENCE : ToMany.valueOf(value);
    }

    public ToOne getToOne() {
        String value = this.getProperties().get(PROP_TO_ONE_REFERENCE_MAPPING);
        return value == null ? ToOne.LIKE_ATTRIBUTES : ToOne.valueOf(value);
    }

    public Map<Object, IDBTable> getReferenceTables() {
        return this.referenceTables;
    }

    public CDOClassRef getClassRef(IDBStoreReader storeReader, int classID) {
        CDOClassRef classRef = this.classRefs.get(classID);
        if (classRef == null) {
            if (classID == -2) {
                IPackageManager packageManager = this.getStore().getRepository().getPackageManager();
                CDOResourceClass resourceClass = packageManager.getCDOResourcePackage().getCDOResourceClass();
                classRef = resourceClass.createClassRef();
            } else {
                classRef = storeReader.readClassRef(classID);
            }
            this.classRefs.put(classID, classRef);
        }
        return classRef;
    }

    @Override
    public IClassMapping getClassMapping(CDOClass cdoClass) {
        IClassMapping mapping = ClassServerInfo.getClassMapping(cdoClass);
        if (mapping == NoClassMapping.INSTANCE) {
            return null;
        }
        if (mapping == null) {
            mapping = this.createClassMapping(cdoClass);
            ClassServerInfo.setClassMapping(cdoClass, mapping == null ? NoClassMapping.INSTANCE : mapping);
        }
        return mapping;
    }

    public IClassMapping getResourceClassMapping() {
        if (this.resourceClassMapping == null) {
            this.initResourceInfos();
        }
        return this.resourceClassMapping;
    }

    public IAttributeMapping getResourcePathMapping() {
        if (this.resourcePathMapping == null) {
            this.initResourceInfos();
        }
        return this.resourcePathMapping;
    }

    public IDBTable getResourceTable() {
        if (this.resourceTable == null) {
            this.initResourceInfos();
        }
        return this.resourceTable;
    }

    public IDBField getResourceIDField() {
        if (this.resourceIDField == null) {
            this.initResourceInfos();
        }
        return this.resourceIDField;
    }

    public IDBField getResourcePathField() {
        if (this.resourcePathField == null) {
            this.initResourceInfos();
        }
        return this.resourcePathField;
    }

    protected void initResourceInfos() {
        IPackageManager packageManager = this.getStore().getRepository().getPackageManager();
        CDOResourceClass resourceClass = packageManager.getCDOResourcePackage().getCDOResourceClass();
        CDOPathFeature pathFeature = packageManager.getCDOResourcePackage().getCDOResourceClass().getCDOPathFeature();
        this.resourceClassMapping = this.getClassMapping((CDOClass)resourceClass);
        this.resourcePathMapping = this.resourceClassMapping.getAttributeMapping((CDOFeature)pathFeature);
        this.resourceTable = this.resourceClassMapping.getTable();
        this.resourceIDField = this.resourceTable.getField("cdo_id");
        this.resourcePathField = this.resourcePathMapping.getField();
    }

    @Override
    public CloseableIterator<CDOID> readObjectIDs(final IDBStoreReader storeReader, final boolean withTypes) {
        List<CDOClass> classes = this.getClassesWithObjectInfo();
        final Iterator<CDOClass> classIt = classes.iterator();
        return new ObjectIDIterator(this, storeReader, withTypes){

            protected ResultSet getNextResultSet() {
                while (classIt.hasNext()) {
                    IDBTable table;
                    CDOClass cdoClass = (CDOClass)classIt.next();
                    IClassMapping mapping = MappingStrategy.this.getClassMapping(cdoClass);
                    if (mapping == null || (table = mapping.getTable()) == null) continue;
                    StringBuilder builder = new StringBuilder();
                    builder.append("SELECT DISTINCT ");
                    builder.append("cdo_id");
                    if (withTypes) {
                        builder.append(", ");
                        builder.append("cdo_class");
                    }
                    builder.append(" FROM ");
                    builder.append(table);
                    String sql = builder.toString();
                    try {
                        return storeReader.getStatement().executeQuery(sql);
                    }
                    catch (SQLException ex) {
                        throw new DBException((Throwable)ex);
                    }
                }
                return null;
            }
        };
    }

    @Override
    public CDOID readResourceID(IDBStoreReader storeReader, String path) {
        IDBTable resourceTable = this.getResourceTable();
        IDBField selectField = this.getResourceIDField();
        IDBField whereField = this.getResourcePathField();
        return (CDOID)this.readResourceInfo(storeReader, resourceTable, selectField, whereField, path);
    }

    @Override
    public String readResourcePath(IDBStoreReader storeReader, CDOID id) {
        IDBTable resourceTable = this.getResourceTable();
        IDBField selectField = this.getResourcePathField();
        IDBField whereField = this.getResourceIDField();
        Long whereValue = CDOIDUtil.getLong((CDOID)id);
        return (String)this.readResourceInfo(storeReader, resourceTable, selectField, whereField, whereValue);
    }

    protected Object readResourceInfo(IDBStoreReader storeReader, IDBTable resourceTable, IDBField selectField, IDBField whereField, Object whereValue) {
        CDOID cDOID;
        ResultSet resultSet;
        block8: {
            String path;
            block7: {
                StringBuilder builder = new StringBuilder();
                builder.append("SELECT ");
                builder.append(selectField);
                builder.append(" FROM ");
                builder.append(resourceTable);
                builder.append(" WHERE ");
                builder.append(whereField);
                builder.append("=");
                this.getStore().getDBAdapter().appendValue(builder, whereField, whereValue);
                String sql = builder.toString();
                if (TRACER.isEnabled()) {
                    TRACER.trace(sql);
                }
                resultSet = null;
                Statement statement = storeReader.getStatement();
                statement.setMaxRows(1);
                resultSet = statement.executeQuery(sql);
                if (resultSet.next()) break block7;
                DBUtil.close((ResultSet)resultSet);
                return null;
            }
            if (!(whereValue instanceof Long)) break block8;
            String string = path = resultSet.getString(1);
            DBUtil.close((ResultSet)resultSet);
            return string;
        }
        try {
            long id = resultSet.getLong(1);
            cDOID = CDOIDUtil.createLong((long)id);
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        return cDOID;
    }

    @Override
    public long repairAfterCrash(Connection connection) {
        long maxCDOID = 0L;
        for (CDOClass idClass : this.getClassesWithObjectInfo()) {
            IClassMapping classMapping = this.getClassMapping(idClass);
            IDBTable table = classMapping.getTable();
            IDBField idField = table.getField("cdo_id");
            long classMaxCDOID = DBUtil.selectMaximumLong((Connection)connection, (IDBField)idField);
            if (TRACER.isEnabled()) {
                TRACER.format("Max CDOID of table {0}: {1}", new Object[]{table, classMaxCDOID});
            }
            maxCDOID = Math.max(maxCDOID, classMaxCDOID);
        }
        return maxCDOID + 2L;
    }

    public String toString() {
        return this.getType();
    }

    protected abstract IClassMapping createClassMapping(CDOClass var1);

    protected abstract List<CDOClass> getClassesWithObjectInfo();

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.store, "store");
    }
}

