/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.db.IClassMapping;
import org.eclipse.emf.cdo.server.db.IDBStoreWriter;
import org.eclipse.emf.cdo.server.internal.db.ClassMapping;
import org.eclipse.emf.cdo.server.internal.db.VerticalMappingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerticalClassMapping
extends ClassMapping {
    private List<IClassMapping> superMappings;

    public VerticalClassMapping(VerticalMappingStrategy mappingStrategy, CDOClass cdoClass) {
        super(mappingStrategy, cdoClass, cdoClass.getFeatures());
        CDOClass[] cDOClassArray = cdoClass.getSuperTypes();
        int n = cDOClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOClass superType = cDOClassArray[n2];
            IClassMapping superMapping = mappingStrategy.getClassMapping(superType);
            if (superMapping != null) {
                if (this.superMappings == null) {
                    this.superMappings = new ArrayList<IClassMapping>(0);
                }
                this.superMappings.add(superMapping);
            }
            ++n2;
        }
    }

    @Override
    public VerticalMappingStrategy getMappingStrategy() {
        return (VerticalMappingStrategy)super.getMappingStrategy();
    }

    @Override
    protected boolean hasFullRevisionInfo() {
        return false;
    }

    public List<IClassMapping> getSuperMappings() {
        return this.superMappings;
    }

    @Override
    public void writeRevision(IDBStoreWriter storeWriter, CDORevision revision) {
        super.writeRevision(storeWriter, revision);
        if (this.superMappings != null) {
            for (IClassMapping superMapping : this.superMappings) {
                superMapping.writeRevision(storeWriter, revision);
            }
        }
    }
}

