/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service.tests;

import java.util.Collections;
import ordersystem.Order;
import ordersystem.OrderSystemFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.CategoryManager;
import org.eclipse.emf.validation.model.ConstraintSeverity;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.AbstractConstraintDescriptor;
import org.eclipse.emf.validation.service.AbstractConstraintProvider;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IParameterizedConstraintDescriptor;
import org.eclipse.emf.validation.service.IParameterizedConstraintParser;
import org.eclipse.emf.validation.tests.TestBase;
import org.eclipse.emf.validation.xml.ConstraintParserException;

public class ParameterizedConstraintParserTest
extends TestBase {
    static final String TEST_LANGUAGE = "***test-lang***";
    static final String TEST_ID1 = "parser-test.id1";
    static final String TEST_ID2 = "parser-test.id2";
    static final String TEST_PARAMETER = "testparm";
    static final String TEST_VALUE = "New parser worked";
    static final String JAVA_MESSAGE = "Java parser worked";
    static final String XML_MESSAGE = "XML provider worked";

    public ParameterizedConstraintParserTest(String name) {
        super(name);
    }

    public void test_provideNonXMLConstraintDescriptorsForCustomLanguage_165455() {
        Order order = OrderSystemFactory.eINSTANCE.createOrder();
        order.getItem().add((Object)OrderSystemFactory.eINSTANCE.createLineItem());
        Constraint.enabled = true;
        IStatus[] statuses = this.getStatuses(this.treeValidator.validate((EObject)order));
        Constraint.enabled = false;
        this.assertAllConstraintsPresent("batch", statuses, TEST_ID1);
        IStatus status = this.getStatus(statuses, TEST_ID1);
        ParameterizedConstraintParserTest.assertEquals((int)2, (int)status.getSeverity());
        ParameterizedConstraintParserTest.assertEquals((String)TEST_VALUE, (String)status.getMessage());
        this.assertAllTargetsPresent("batch", new IStatus[]{status}, Collections.singleton(order));
    }

    public void test_provideNonXMLConstraintDescriptorsForJavaLanguage_165455() {
        Order order = OrderSystemFactory.eINSTANCE.createOrder();
        order.getItem().add((Object)OrderSystemFactory.eINSTANCE.createLineItem());
        JavaConstraint.enabled = true;
        IStatus[] statuses = this.getStatuses(this.treeValidator.validate((EObject)order));
        JavaConstraint.enabled = false;
        this.assertAllConstraintsPresent("batch", statuses, TEST_ID2);
        IStatus status = this.getStatus(statuses, TEST_ID2);
        ParameterizedConstraintParserTest.assertEquals((int)2, (int)status.getSeverity());
        ParameterizedConstraintParserTest.assertEquals((String)JAVA_MESSAGE, (String)status.getMessage());
        this.assertAllTargetsPresent("batch", new IStatus[]{status}, Collections.singleton(order));
    }

    public void test_provideXMLConstraintDescriptorsForCustomLanguage_165455() {
        Order order = OrderSystemFactory.eINSTANCE.createOrder();
        order.getItem().add((Object)OrderSystemFactory.eINSTANCE.createLineItem());
        Constraint.enabled = true;
        IStatus[] statuses = this.getStatuses(this.treeValidator.validate((EObject)order));
        Constraint.enabled = false;
        this.assertAllConstraintsPresent("batch", statuses, "org.eclipse.emf.validation.tests.order.newParserAPI");
        IStatus status = this.getStatus(statuses, "org.eclipse.emf.validation.tests.order.newParserAPI");
        ParameterizedConstraintParserTest.assertEquals((int)4, (int)status.getSeverity());
        ParameterizedConstraintParserTest.assertEquals((String)XML_MESSAGE, (String)status.getMessage());
        this.assertAllTargetsPresent("batch", new IStatus[]{status}, Collections.singleton(order));
    }

    private static final class Constraint
    implements IModelConstraint {
        static boolean enabled = false;
        private final IConstraintDescriptor descriptor;
        private final String errorMessage;

        Constraint(IConstraintDescriptor descriptor, String errorMessage) {
            this.descriptor = descriptor;
            this.errorMessage = errorMessage;
        }

        public IConstraintDescriptor getDescriptor() {
            return this.descriptor;
        }

        public IStatus validate(IValidationContext ctx) {
            ParameterizedConstraintParserTest.assertTrue((boolean)(ctx.getTarget() instanceof Order));
            if (!enabled) {
                return ctx.createSuccessStatus();
            }
            return ctx.createFailureStatus(new Object[]{this.errorMessage});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Descriptor
    extends AbstractConstraintDescriptor
    implements IParameterizedConstraintDescriptor {
        private final String id;
        private final String lang;

        Descriptor(String id, String lang) {
            this.id = id;
            this.lang = lang;
            this.addCategory(CategoryManager.getInstance().findCategory("junit/validation"));
        }

        public String getLanguage() {
            return this.lang;
        }

        public String getParameterValue(String name) {
            if (ParameterizedConstraintParserTest.TEST_PARAMETER.equals(name)) {
                return ParameterizedConstraintParserTest.TEST_VALUE;
            }
            if ("class".equals(name)) {
                return JavaConstraint.class.getName();
            }
            if ("bundle".equals(name)) {
                return this.getPluginId();
            }
            return null;
        }

        public String getBody() {
            return null;
        }

        public String getDescription() {
            return "Test constraint";
        }

        public EvaluationMode<?> getEvaluationMode() {
            return EvaluationMode.BATCH;
        }

        public String getId() {
            return this.id;
        }

        public String getMessagePattern() {
            return "{0}";
        }

        public String getName() {
            return "test constraint";
        }

        public String getPluginId() {
            return "org.eclipse.emf.validation.tests";
        }

        public ConstraintSeverity getSeverity() {
            return ConstraintSeverity.WARNING;
        }

        public int getStatusCode() {
            return 1;
        }

        public boolean targetsEvent(Notification notification) {
            return notification.getNotifier() instanceof Order;
        }

        public boolean targetsTypeOf(EObject eObject) {
            return eObject instanceof Order;
        }
    }

    public static final class JavaConstraint
    extends AbstractModelConstraint {
        static boolean enabled = false;

        public IStatus validate(IValidationContext ctx) {
            ParameterizedConstraintParserTest.assertTrue((boolean)(ctx.getTarget() instanceof Order));
            if (!enabled) {
                return ctx.createSuccessStatus();
            }
            return ctx.createFailureStatus(new Object[]{ParameterizedConstraintParserTest.JAVA_MESSAGE});
        }
    }

    public static final class Parser
    implements IParameterizedConstraintParser {
        public IModelConstraint parseConstraint(IParameterizedConstraintDescriptor descriptor) throws ConstraintParserException {
            return new Constraint((IConstraintDescriptor)descriptor, descriptor.getParameterValue(ParameterizedConstraintParserTest.TEST_PARAMETER));
        }
    }

    public static final class Provider
    extends AbstractConstraintProvider {
        public Provider() {
            Descriptor desc = new Descriptor(ParameterizedConstraintParserTest.TEST_ID1, ParameterizedConstraintParserTest.TEST_LANGUAGE);
            IModelConstraint proxy = this.createModelConstraintProxy((IConstraintDescriptor)desc);
            this.getConstraints().add(proxy);
            desc = new Descriptor(ParameterizedConstraintParserTest.TEST_ID2, "Java");
            proxy = this.createModelConstraintProxy((IConstraintDescriptor)desc);
            this.getConstraints().add(proxy);
        }
    }
}

