/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.eef.runtime.ui.utils.EditingUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RadioViewer
extends Composite
implements ISelectionProvider {
    private List<ISelectionChangedListener> listeners;
    private RadioSelectionChangedListener radioSelectionChangedListener;
    private Map<Object, Button> buttons = new HashMap<Object, Button>();

    public RadioViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        this.listeners = new ArrayList<ISelectionChangedListener>();
        EditingUtils.setEEFtype((Control)this, "eef::RadioViewer");
        this.radioSelectionChangedListener = new RadioSelectionChangedListener();
    }

    private void createButton(Object value) {
        Button b = new Button((Composite)this, 16);
        if (value instanceof Enumerator) {
            b.setText(((Enumerator)value).getLiteral());
        }
        GridData data = new GridData(1808);
        b.setLayoutData((Object)data);
        b.addSelectionListener((SelectionListener)this.radioSelectionChangedListener);
        this.buttons.put(value, b);
        EditingUtils.setEEFtype((Control)b, "eef::RadioViewer::radio");
        if (EditingUtils.getID((Control)this) != null) {
            EditingUtils.setID((Control)b, EditingUtils.getID((Control)this));
        }
    }

    public void setEnabled(boolean enabled) {
        for (Button button : this.buttons.values()) {
            button.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection sSelection = (StructuredSelection)selection;
            Object newValue = sSelection.getFirstElement();
            for (Object value : this.buttons.keySet()) {
                this.buttons.get(value).setSelection(false);
                if (!(value instanceof Enumerator) || !(newValue instanceof Enumerator) || ((Enumerator)value).getValue() != ((Enumerator)newValue).getValue()) continue;
                this.buttons.get(value).setSelection(true);
            }
        }
    }

    public ISelection getSelection() {
        for (Object value : this.buttons.keySet()) {
            if (!this.buttons.get(value).getSelection()) continue;
            return new StructuredSelection(value);
        }
        return null;
    }

    public void setInput(Object input) {
        if (input instanceof Collection) {
            for (Object value : (Collection)input) {
                this.createButton(value);
            }
        }
        GridLayout l = (GridLayout)this.getLayout();
        l.numColumns = this.buttons.size() == 0 ? 1 : this.buttons.size();
        this.setLayout((Layout)l);
        this.layout();
    }

    public void setID(Object id) {
        EditingUtils.setID((Control)this, id);
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            EditingUtils.setID(control, id);
            ++n2;
        }
    }

    public Object getID() {
        return EditingUtils.getID((Control)this);
    }

    public void setToolTipText(String tooltip) {
        for (Button button : this.buttons.values()) {
            button.setToolTipText(tooltip);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    private class RadioSelectionChangedListener
    extends SelectionAdapter {
        private RadioSelectionChangedListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object value = null;
            for (Object tmp : RadioViewer.this.buttons.keySet()) {
                if (!((Button)RadioViewer.this.buttons.get(tmp)).getSelection()) continue;
                value = tmp;
            }
            if (value != null) {
                for (ISelectionChangedListener listener : RadioViewer.this.listeners) {
                    listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)RadioViewer.this, (ISelection)new StructuredSelection(value)));
                }
            }
        }
    }
}

