/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.henshin.diagram.edit.helpers.ModuleEditHelper;
import org.eclipse.emf.henshin.diagram.edit.helpers.RootObjectEditHelper;
import org.eclipse.emf.henshin.diagram.edit.helpers.RuleEditHelper;
import org.eclipse.emf.henshin.diagram.parsers.UnitNameParser;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.notation.View;

public class RuleNameParser
extends UnitNameParser {
    public RuleNameParser(View view) {
        super(view);
        if (!RuleEditHelper.isRuleView(view)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected boolean isUnitEmpty(Unit unit) {
        if (unit instanceof Rule) {
            Rule rule = (Rule)unit;
            return rule.getLhs().getNodes().isEmpty() && rule.getRhs().getNodes().isEmpty() && rule.getParameters().isEmpty();
        }
        return super.isUnitEmpty(unit);
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        String root = "";
        Node rootObject = RootObjectEditHelper.getRootObject(this.unitView);
        if (rootObject != null) {
            root = " @" + rootObject.getType().getName();
        }
        return String.valueOf(super.getPrintString(element, flags)) + root;
    }

    @Override
    protected CommandResult doParsing(String value) throws ExecutionException {
        String rootType;
        String name;
        Rule rule = (Rule)this.unitView.getElement();
        int at = value.indexOf(64);
        if (at < 0) {
            name = value;
            rootType = null;
        } else {
            name = value.substring(0, at).trim();
            rootType = value.substring(at + 1).trim();
            if (rootType.isEmpty()) {
                rootType = null;
            }
        }
        super.doParsing(name);
        Node oldRoot = RootObjectEditHelper.getRootObject(this.unitView);
        if (!(rootType == null || oldRoot != null && rootType.equals(oldRoot.getType().getName()))) {
            EClassifier[] classifiers;
            EClass rootClass = null;
            EClassifier[] eClassifierArray = classifiers = ModuleEditHelper.getEClassifiers(rule.getModule(), rootType);
            int n = classifiers.length;
            int n2 = 0;
            while (n2 < n) {
                EClassifier classifier = eClassifierArray[n2];
                if (classifier instanceof EClass) {
                    rootClass = (EClass)classifier;
                    break;
                }
                ++n2;
            }
            if (rootClass != null) {
                RootObjectEditHelper.setRootObjectType(this.unitView, rootClass);
            }
        }
        if (rootType == null && oldRoot != null) {
            RootObjectEditHelper.setRootObject(this.unitView, null);
        }
        return CommandResult.newOKCommandResult();
    }

    @Override
    protected void handleParametersChange(Unit unit) {
        Rule rule = (Rule)unit;
        for (Rule multiRule : rule.getMultiRules()) {
            while (multiRule.getParameters().size() < rule.getParameters().size()) {
                multiRule.getParameters().add((Object)HenshinFactory.eINSTANCE.createParameter());
            }
            while (multiRule.getParameters().size() > rule.getParameters().size()) {
                multiRule.getParameters().remove(multiRule.getParameters().size() - 1);
            }
            int i = 0;
            while (i < rule.getParameters().size()) {
                Parameter s = (Parameter)rule.getParameters().get(i);
                Parameter t = (Parameter)multiRule.getParameters().get(i);
                t.setName(s.getName());
                t.setType(s.getType());
                t.setDescription(s.getDescription());
                ++i;
            }
            this.handleParametersChange((Unit)multiRule);
        }
    }
}

