/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.model.ConditionalUnit;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.MultiUnit;
import org.eclipse.emf.henshin.model.UnaryUnit;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;

public class InvocationCreateCommand
extends EditElementCommand {
    public InvocationCreateCommand(CreateElementRequest req) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
    }

    protected EObject getElementToEdit() {
        EObject container = ((CreateElementRequest)this.getRequest()).getContainer();
        if (container instanceof View) {
            container = ((View)container).getElement();
        }
        return container;
    }

    public boolean canExecute() {
        return !this.getTargetCandidates().isEmpty();
    }

    private Module getModule() {
        EObject object = this.getElementToEdit();
        while (object != null) {
            if (object instanceof Module) {
                return (Module)object;
            }
            object = object.eContainer();
        }
        return null;
    }

    private List<Unit> getTargetCandidates() {
        ArrayList<Unit> candidates = new ArrayList<Unit>();
        Module system = this.getModule();
        if (system != null) {
            candidates.addAll((Collection<Unit>)system.getUnits());
        }
        return candidates;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Unit owner = (Unit)this.getElementToEdit();
        List<Unit> candidates = this.getTargetCandidates();
        for (Unit used : owner.getSubUnits(false)) {
            if (candidates.size() <= 1) break;
            candidates.remove(used);
        }
        Unit target = candidates.get(0);
        if (owner instanceof MultiUnit) {
            ((MultiUnit)owner).getSubUnits().add((Object)target);
        } else if (owner instanceof UnaryUnit) {
            if (((UnaryUnit)owner).getSubUnit() == null) {
                ((UnaryUnit)owner).setSubUnit(target);
            }
        } else if (owner instanceof ConditionalUnit) {
            ConditionalUnit cond = (ConditionalUnit)owner;
            if (cond.getIf() == null) {
                cond.setIf(target);
            } else if (cond.getThen() == null) {
                cond.setThen(target);
            } else if (cond.getElse() == null) {
                cond.setElse(target);
            }
        }
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)target);
        return CommandResult.newOKCommandResult((Object)target);
    }

    protected void doConfigure(Unit newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }
}

