/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.computation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.henshin.multicda.cda.conflict.EssentialConflictReason;
import org.eclipse.emf.henshin.multicda.cda.units.Atom;
import org.eclipse.emf.henshin.multicda.cda.units.Reason;

public class ReasonComputation {
    public Set<EssentialConflictReason> computeConflictReasons(List<Atom.ConflictAtom> conflictAtoms, Set<Reason> initialReasons) {
        HashSet<EssentialConflictReason> conflictReasonsDerivedFromInitialReason = new HashSet<EssentialConflictReason>();
        HashSet<Reason> originMCRs = new HashSet<Reason>();
        for (Reason initialReason : initialReasons) {
            originMCRs.addAll(initialReason.getOriginMCRs());
            Set<Atom> byInitialReasonCoveredEdgeConflictAtoms = initialReason.getCoveredEdgeConflictAtoms();
            Set<Atom.ConflictAtom> allEdgeConflictAtoms = this.extractEdgeConflictAtoms(conflictAtoms);
            allEdgeConflictAtoms.removeAll(byInitialReasonCoveredEdgeConflictAtoms);
            Set<Atom.ConflictAtom> byInitialReasonUncoveredConflictAtoms = allEdgeConflictAtoms;
            Set<EssentialConflictReason> allDerivedConflictReasons = initialReason.getAllDerivedConflictReasons(byInitialReasonUncoveredConflictAtoms);
            conflictReasonsDerivedFromInitialReason.addAll(allDerivedConflictReasons);
        }
        return conflictReasonsDerivedFromInitialReason;
    }

    public Set<Atom.ConflictAtom> extractEdgeConflictAtoms(List<Atom.ConflictAtom> computedConflictAtoms) {
        HashSet<Atom.ConflictAtom> edgeConflictAtoms = new HashSet<Atom.ConflictAtom>();
        for (Atom.ConflictAtom ca : computedConflictAtoms) {
            if (!ca.isDeleteEdgeConflictAtom()) continue;
            edgeConflictAtoms.add(ca);
        }
        return edgeConflictAtoms;
    }
}

