/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.gc2ac.util;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;

public class RuleClassifier {
    private Rule rule;
    public EList<Node> createActionNodes;
    public EList<Edge> createActionEdges;
    EList<Attribute> createActionAttributes;
    EList<Object> createActionElements = new BasicEList();
    public EList<Node> deleteActionNodes;
    EList<Edge> deleteActionEdges;
    EList<Attribute> deleteActionAttributes;
    EList<Object> deleteActionElements = new BasicEList();
    EList<Node> forbidActionNodes;
    EList<Edge> forbidActionEdges;
    EList<Attribute> forbidActionAttributes;
    EList<Object> forbidActionElements = new BasicEList();
    EList<Node> requireActionNodes;
    EList<Edge> requireActionEdges;
    EList<Attribute> requireActionAttributes;
    EList<Object> requireActionElements = new BasicEList();
    public EList<Node> preserveActionNodes;
    EList<Edge> preserveActionEdges;
    EList<Attribute> preserveActionAttributes;
    EList<Object> preserveActionElements = new BasicEList();

    public RuleClassifier(Rule rule) {
        this.rule = rule;
        this.createActionNodes = this.getActionNodes(Action.Type.CREATE);
        this.createActionEdges = this.getActionEdges(Action.Type.CREATE);
        this.createActionAttributes = this.getCreateActionAttributes();
        this.createActionElements.addAll(this.createActionNodes);
        this.createActionElements.addAll(this.createActionEdges);
        this.createActionElements.addAll(this.createActionAttributes);
        this.deleteActionNodes = this.getActionNodes(Action.Type.DELETE);
        this.deleteActionEdges = this.getActionEdges(Action.Type.DELETE);
        this.deleteActionAttributes = this.getDeleteActionAttributes();
        this.deleteActionElements.addAll(this.deleteActionNodes);
        this.deleteActionElements.addAll(this.deleteActionEdges);
        this.deleteActionElements.addAll(this.deleteActionAttributes);
        this.requireActionNodes = this.getActionNodes(Action.Type.REQUIRE);
        this.requireActionEdges = this.getActionEdges(Action.Type.REQUIRE);
        this.requireActionAttributes = this.getRequireActionAttributes();
        this.requireActionElements.addAll(this.requireActionNodes);
        this.requireActionElements.addAll(this.requireActionEdges);
        this.requireActionElements.addAll(this.requireActionAttributes);
        this.forbidActionNodes = this.getActionNodes(Action.Type.FORBID);
        this.forbidActionEdges = this.getActionEdges(Action.Type.FORBID);
        this.forbidActionAttributes = this.getForbidActionAttributes();
        this.forbidActionElements.addAll(this.forbidActionNodes);
        this.forbidActionElements.addAll(this.forbidActionEdges);
        this.forbidActionElements.addAll(this.forbidActionAttributes);
        this.preserveActionNodes = this.getActionNodes(Action.Type.PRESERVE);
        this.preserveActionEdges = this.getActionEdges(Action.Type.PRESERVE);
        this.preserveActionAttributes = this.getPreserveActionAttributes();
        this.preserveActionElements.addAll(this.preserveActionNodes);
        this.preserveActionElements.addAll(this.preserveActionEdges);
        this.preserveActionElements.addAll(this.preserveActionAttributes);
    }

    public int getRuleSize() {
        return this.createActionElements.size() + this.deleteActionElements.size() + this.requireActionElements.size() + this.forbidActionElements.size() + this.preserveActionElements.size();
    }

    public boolean doesRuleCreateOnly() {
        return this.createActionElements != null && this.deleteActionElements.size() == 0 && this.forbidActionElements.size() == 0 && this.requireActionElements.size() == 0;
    }

    public boolean doesRuleDeleteOnly() {
        return this.deleteActionElements != null && this.createActionElements.size() == 0 && this.forbidActionElements.size() == 0 && this.requireActionElements.size() == 0;
    }

    private EList<Edge> getActionEdges(Action.Type action) {
        return this.rule.getActionEdges(new Action(action));
    }

    private EList<Node> getActionNodes(Action.Type action) {
        return this.rule.getActionNodes(new Action(action));
    }

    private EList<Attribute> getCreateActionAttributes() {
        BasicEList createActionAttributes = new BasicEList();
        for (Node node : this.rule.getRhs().getNodes()) {
            for (Attribute attr : node.getAttributes()) {
                if (attr.getAction() == null || attr.getAction().getType() != Action.Type.CREATE) continue;
                createActionAttributes.add((Object)attr);
            }
        }
        return createActionAttributes;
    }

    private EList<Attribute> getDeleteActionAttributes() {
        BasicEList deleteActionAttributes = new BasicEList();
        for (Node node : this.rule.getLhs().getNodes()) {
            for (Attribute attr : node.getAttributes()) {
                if (attr.getAction().getType() != Action.Type.DELETE) continue;
                deleteActionAttributes.add((Object)attr);
            }
        }
        return deleteActionAttributes;
    }

    private EList<Attribute> getForbidActionAttributes() {
        BasicEList forbidActionAttributes = new BasicEList();
        for (Node node : this.rule.getLhs().getNodes()) {
            for (Attribute attr : node.getAttributes()) {
                if (attr.getAction().getType() != Action.Type.FORBID) continue;
                forbidActionAttributes.add((Object)attr);
            }
        }
        return forbidActionAttributes;
    }

    private EList<Attribute> getRequireActionAttributes() {
        BasicEList requireActionAttributes = new BasicEList();
        for (Node node : this.rule.getLhs().getNodes()) {
            for (Attribute attr : node.getAttributes()) {
                if (attr.getAction().getType() != Action.Type.REQUIRE) continue;
                requireActionAttributes.add((Object)attr);
            }
        }
        return requireActionAttributes;
    }

    private EList<Attribute> getPreserveActionAttributes() {
        BasicEList preserveActionAttributes = new BasicEList();
        for (Node node : this.rule.getLhs().getNodes()) {
            for (Attribute attr : node.getAttributes()) {
                if (attr.getAction().getType() != Action.Type.PRESERVE) continue;
                preserveActionAttributes.add((Object)attr);
            }
        }
        return preserveActionAttributes;
    }
}

