/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.clone;

import de.parsemis.miner.general.Fragment;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.mergein.clone.AbstractCloneGroupDetector;
import org.eclipse.emf.henshin.variability.mergein.clone.CloneGroup;
import org.eclipse.emf.henshin.variability.mergein.mining.MiningManager;
import org.eclipse.emf.henshin.variability.mergein.mining.MiningManagerFactory;
import org.eclipse.emf.henshin.variability.mergein.mining.labels.IEdgeLabel;
import org.eclipse.emf.henshin.variability.mergein.mining.labels.INodeLabel;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinGraph;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinGraphElement;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinGraphFactory;
import org.eclipse.emf.henshin.variability.mergein.normalize.RuleToHenshinGraphMap;

public class GraphMiningBasedCloneGroupDetector
extends AbstractCloneGroupDetector {
    public GraphMiningBasedCloneGroupDetector(List<Rule> rules) {
        super(rules);
    }

    public GraphMiningBasedCloneGroupDetector(EList<Rule> rules, boolean b) {
        super((List<Rule>)rules, b);
    }

    @Override
    public void detectCloneGroups() {
        RuleToHenshinGraphMap ruleGraphs = HenshinGraphFactory.getInstance().createIntegratedGraphs(this.rules, this.includeRhs);
        MiningManager miningManager = MiningManagerFactory.getInstance().createNewMiningManager(ruleGraphs.getHenshinGraphs(), 1);
        miningManager.doMining();
        this.result = new HashSet();
        for (Fragment<INodeLabel, IEdgeLabel> fragment : miningManager.getMinedFragments()) {
            ArrayList<Rule> affected = new ArrayList<Rule>();
            List<Set<HenshinGraphElement>> elementsOfEmbeddings = miningManager.getGraphElementsOfEmbeddings(fragment);
            for (Set<HenshinGraphElement> set : elementsOfEmbeddings) {
                HenshinGraph graph = set.iterator().next().getHenshinGraph();
                Rule rule = ruleGraphs.get(graph);
                affected.add(rule);
            }
            Map<Edge, Map<Rule, Edge>> edgeMappings = this.convertEdgeMappings(miningManager.createHenshinEdgeMappings(fragment), ruleGraphs);
            Map<Attribute, Map<Rule, Attribute>> attributeMappings = this.convertAttributeMappings(miningManager.createHenshinAttributeMappings(fragment), ruleGraphs);
            this.result.add(new CloneGroup(affected, edgeMappings, attributeMappings));
        }
    }
}

