/*******************************************************************************
 * Copyright (c) 2005 - 2006 Joel Cheuoua & others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Joel Cheuoua - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.codegen.jet.editor.util.keywords;

import java.util.ArrayList;
import java.util.TreeMap;
import java.util.TreeSet;

/**
 * @author jcheuoua
 * 
 * To change the template for this generated type comment go to Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code
 * and Comments
 * @version $Revision: 1.2 $
 */
public class JETTemplateDirectiveKeywords {
  private static String rootTags[] = { "jet", "include" };

  private static String tags[][] = {
      { "jet", "skeleton", "package", "imports", "class", "nlString", "startTag", "endTag", "extends", "implements",
          "methodname", "methodName", "throws", "parameters", "writer" }, { "include", "file" } };

  private static TreeSet keywordSet;

  private static TreeSet innerKeywordSet;

  private static TreeMap innerMap;

  static {
    keywordSet = new TreeSet();
    innerKeywordSet = new TreeSet();
    innerMap = new TreeMap();
    for (int i = 0; i < tags.length; i++)
      keywordSet.add(tags[i][0]);

    for (int i = 0; i < tags.length; i++) {
      TreeSet innerSet = new TreeSet();
      for (int j = 1; j < tags[i].length; j++) {
        innerSet.add(tags[i][j]);
        innerKeywordSet.add(tags[i][j]);
      }
      innerMap.put(tags[i][0], innerSet);
    }
  }

  /**
   * Method getAllKeywords.
   * @return String[]
   */
  public static String[] getAllKeywords() {
    return (String[]) keywordSet.toArray(new String[keywordSet.size()]);
  }

  /**
   * Method getAllInnerKeywords.
   * @return String[]
   */
  public static String[] getAllInnerKeywords() {
    return (String[]) innerKeywordSet.toArray(new String[innerKeywordSet.size()]);
  }

  /**
   * Method getTags.
   * @return String[]
   */
  public static String[] getTags() {
    return rootTags;
  }

  /**
   * Method getInnerKeywordsFor.
   * @param key String
   * @return String[]
   */
  public static String[] getInnerKeywordsFor(String key) {
    TreeSet set = (TreeSet) innerMap.get(key);
    if (set == null && key.length() == 0)
      return getTags();
    else
      return (String[]) set.toArray(new String[set.size()]);
  }

  /**
   * Method prefixMatches.
   * @param prefix String
   * @param word String
   * @return boolean
   */
  private static boolean prefixMatches(String prefix, String word) {
    prefix = prefix.toLowerCase();
    return word.startsWith(prefix);
  }

  /**
   * Method getAllWordsWithPrefix.
   * @param prefix String
   * @return String[]
   */
  public static String[] getAllWordsWithPrefix(String prefix) {
    String all[] = getAllKeywords();
    return getMatched(prefix, all);
  }

  /**
   * Method getMatched.
   * @param prefix String
   * @param all String[]
   * @return String[]
   */
  private static String[] getMatched(String prefix, String all[]) {
    ArrayList matched = new ArrayList(10);
    for (int i = 0; i < all.length; i++)
      if (prefixMatches(prefix, all[i]))
        matched.add(all[i]);

    return (String[]) matched.toArray(new String[matched.size()]);
  }

  /**
   * Method getTagsWithPrefix.
   * @param prefix String
   * @return String[]
   */
  public static String[] getTagsWithPrefix(String prefix) {
    return getMatched(prefix, getTags());
  }

  /**
   * Method getNonTagsKeywordsWithPrefix.
   * @param key String
   * @param prefix String
   * @return String[]
   */
  public static String[] getNonTagsKeywordsWithPrefix(String key, String prefix) {
    return getMatched(prefix, getInnerKeywordsFor(key));
  }
}
