/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.epatch.recorder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfRecorder
implements Adapter.Internal {
    protected RecorderListener listener;
    protected boolean recording = false;
    protected boolean resolveProxies;
    protected List<Notifier> rootObjects = new ArrayList<Notifier>();
    protected List<Notifier> targetObjects = new BasicEList.FastCompare();

    public EmfRecorder(RecorderListener listener) {
        this.listener = listener;
    }

    protected void addAdapter(Notifier notifier, boolean isRoot) {
        EList eAdapters = notifier.eAdapters();
        if (!eAdapters.contains((Object)this)) {
            eAdapters.add((Object)this);
        }
    }

    public void addRootObject(Notifier obj) {
        this.rootObjects.add(obj);
        if (this.recording) {
            this.addAdapter(obj, true);
        }
    }

    public void beginRecording() {
        Iterator<Notifier> iterator = this.rootObjects.iterator();
        while (iterator.hasNext()) {
            Notifier rootObject;
            Notifier notifier = rootObject = iterator.next();
            this.addAdapter(notifier, true);
        }
        this.recording = true;
    }

    public void dispose() {
        this.recording = false;
        Notifier[] notifierArray = this.rootObjects.toArray(new Notifier[this.rootObjects.size()]);
        int n = notifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            Notifier r = notifierArray[n2];
            this.removeRootObject(r);
            ++n2;
        }
        Notifier[] notifiers = this.targetObjects.toArray(new Notifier[this.targetObjects.size()]);
        this.targetObjects.clear();
        Notifier[] notifierArray2 = notifiers;
        int n3 = notifiers.length;
        n = 0;
        while (n < n3) {
            Notifier n4 = notifierArray2[n];
            this.removeAdapter(n4, false);
            ++n;
        }
    }

    public void endRecording() {
        if (this.recording) {
            this.recording = false;
        }
    }

    public List<Notifier> getRootObjects() {
        return this.rootObjects;
    }

    public Notifier getTarget() {
        return null;
    }

    protected void handleFeature(EStructuralFeature feature, EReference containment, Notification notification, EObject eObject) {
        this.listener.handleFeature(feature, containment, notification, eObject);
        if (containment == null) {
            return;
        }
        switch (notification.getEventType()) {
            case 1: 
            case 2: 
            case 9: {
                Object newValue = notification.getNewValue();
                if (newValue == null || newValue == Boolean.TRUE || newValue == Boolean.FALSE) break;
                this.addAdapter((Notifier)newValue, false);
                break;
            }
            case 3: {
                Notifier newValue1 = (Notifier)notification.getNewValue();
                this.addAdapter(newValue1, false);
                break;
            }
            case 5: {
                Collection newValues = (Collection)notification.getNewValue();
                for (Notifier newValue2 : newValues) {
                    this.addAdapter(newValue2, false);
                }
                break;
            }
            case 4: {
                break;
            }
            case 6: {
                break;
            }
        }
    }

    protected void handleResource(Resource resource, Notification notification) {
        switch (notification.getFeatureID(Resource.class)) {
            case 2: {
                if (!((Resource.Internal)resource).isLoading()) {
                    int eventType = notification.getEventType();
                    switch (eventType) {
                        case 1: 
                        case 2: {
                            Notifier newValue = (Notifier)notification.getNewValue();
                            if (newValue == null) break;
                            this.addAdapter(newValue, false);
                            break;
                        }
                        case 3: {
                            Notifier newValue1 = (Notifier)notification.getNewValue();
                            this.addAdapter(newValue1, false);
                            break;
                        }
                        case 5: {
                            Collection newValues = (Collection)notification.getNewValue();
                            for (Notifier newValue2 : newValues) {
                                this.addAdapter(newValue2, false);
                            }
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 6: {
                            break;
                        }
                    }
                }
            }
            case 4: {
                for (Notifier content : resource.getContents()) {
                    this.addAdapter(content, false);
                }
                break;
            }
        }
    }

    protected void handleResourceSet(ResourceSet resourceSet, Notification notification) {
        if (notification.getFeatureID(ResourceSet.class) == 0) {
            switch (notification.getEventType()) {
                case 1: 
                case 3: {
                    Resource resource = (Resource)notification.getNewValue();
                    this.addAdapter((Notifier)resource, false);
                    break;
                }
                case 5: {
                    Collection resources = (Collection)notification.getNewValue();
                    for (Resource resource1 : resources) {
                        this.addAdapter((Notifier)resource1, false);
                    }
                    break;
                }
            }
        }
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    protected boolean isObserved(Notifier not) {
        return not.eAdapters().contains((Object)this);
    }

    public boolean isRecording() {
        return this.recording;
    }

    public boolean isResolveProxies() {
        return this.resolveProxies;
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof EObject) {
            Object feature = notification.getFeature();
            if (feature instanceof EReference) {
                EReference eReference;
                this.handleFeature((EStructuralFeature)eReference, (EReference)((eReference = (EReference)feature).isContainment() ? eReference : null), notification, (EObject)notifier);
            } else if (feature != null) {
                this.handleFeature((EStructuralFeature)feature, null, notification, (EObject)notifier);
            }
        } else if (notifier instanceof Resource) {
            this.handleResource((Resource)notifier, notification);
        } else if (notifier instanceof ResourceSet) {
            this.handleResourceSet((ResourceSet)notifier, notification);
        }
    }

    protected void removeAdapter(Notifier notifier, boolean isRoot) {
        notifier.eAdapters().remove((Object)this);
    }

    public void removeRootObject(Notifier obj) {
        this.rootObjects.remove(obj);
        if (this.recording) {
            this.removeAdapter(obj, true);
        }
    }

    public void setResolveProxies(boolean resolveProxies) {
        this.resolveProxies = resolveProxies;
    }

    public void setTarget(Notifier target) {
        Iterator contents;
        if (!this.targetObjects.add(target)) {
            throw new IllegalStateException("The target should not be set more than once");
        }
        Iterator iterator = target instanceof EObject ? (this.resolveProxies ? ((EObject)target).eContents().iterator() : ((InternalEList)((EObject)target).eContents()).basicIterator()) : (target instanceof ResourceSet ? ((ResourceSet)target).getResources().iterator() : (contents = target instanceof Resource ? ((Resource)target).getContents().iterator() : null));
        if (contents != null) {
            while (contents.hasNext()) {
                Notifier notifier = (Notifier)contents.next();
                this.addAdapter(notifier, false);
            }
        }
    }

    public void unsetTarget(Notifier oldTarget) {
        this.targetObjects.remove(oldTarget);
    }

    public static interface RecorderListener {
        public void handleFeature(EStructuralFeature var1, EReference var2, Notification var3, EObject var4);
    }
}

