/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.rt;

import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.codegen.gmfgen.GenMetricContainer;
import org.eclipse.gmf.codegen.gmfgen.GenMetricRule;
import org.eclipse.gmf.mappings.MetricContainer;
import org.eclipse.gmf.tests.rt.RuntimeDiagramTestBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricRulesTest
extends RuntimeDiagramTestBase {
    private MetricContainer metricContainer;
    private GenMetricContainer genMetricContainer;

    public MetricRulesTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.metricContainer = this.getSetup().getMapModel().getMapping().getMetrics();
        this.genMetricContainer = this.getGenModel().getGenDiagram().getEditorGen().getMetrics();
        MetricRulesTest.assertTrue((String)"Setup with at least one metric definition required", (this.metricContainer != null && !this.metricContainer.getMetrics().isEmpty() ? 1 : 0) != 0);
    }

    public void testMetrics() throws Exception {
        MetricRulesTest.assertTrue((String)"Problem in gen-model transformation detected", (this.genMetricContainer != null && this.genMetricContainer.getMetrics().size() == this.metricContainer.getMetrics().size() ? 1 : 0) != 0);
        Class<?> providerClass = null;
        Class<?> viewClass = null;
        try {
            providerClass = this.loadGeneratedClass(this.getGenModel().getGenDiagram().getMetricProviderQualifiedClassName());
            viewClass = this.loadGeneratedClass(String.valueOf(this.getGenModel().getGenDiagram().getMetricProviderQualifiedClassName()) + "$ResultView");
        }
        catch (ClassNotFoundException classNotFoundException) {
            MetricRulesTest.fail((String)"Could not find generated metric provider or view");
        }
        Method metricAccessor = null;
        try {
            metricAccessor = providerClass.getMethod("getMetrics", null);
        }
        catch (Exception exception) {
            MetricRulesTest.fail((String)"Could not find generated metric definitions accessor");
        }
        List metrics = (List)metricAccessor.invoke(viewClass, null);
        MetricRulesTest.assertEquals((String)"All metrics from gmfmap must be registered", (int)metrics.size(), (int)this.metricContainer.getMetrics().size());
        this.assertMetricEvaluation(providerClass);
    }

    private void assertMetricEvaluation(Class<?> metricProviderClass) {
        Method calcMetricMethod = null;
        try {
            calcMetricMethod = metricProviderClass.getMethod("calculateMetric", String.class, Object.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            MetricRulesTest.fail((String)("Could not find calculateMetric method in the provider. " + e.toString()));
        }
        for (GenMetricRule nextRule : this.genMetricContainer.getMetrics()) {
            EClassifier eClassifier = nextRule.getTarget().getContext().getEcoreClassifier();
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(eClassifier.getEPackage().getNsURI());
            MetricRulesTest.assertNotNull((String)"EPackage must be already generated and initialized", (Object)ePackage);
            EClassifier generatedClassifier = ePackage.getEClassifier(eClassifier.getName());
            MetricRulesTest.assertNotNull((String)"Could not find metric target classifier", (Object)generatedClassifier);
            EObject contextInstance = ePackage.getEFactoryInstance().create((EClass)generatedClassifier);
            try {
                Object metricValue = calcMetricMethod.invoke(null, nextRule.getKey(), contextInstance);
                MetricRulesTest.assertTrue((boolean)(metricValue instanceof Number));
            }
            catch (Exception e) {
                MetricRulesTest.fail((String)("Metric rule evaluation failed. " + e.toString()));
            }
        }
    }
}

