/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.handles;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandleLocator;
import org.eclipse.gmf.runtime.diagram.ui.internal.l10n.DiagramUIPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.internal.tools.ConnectionHandleTool;
import org.eclipse.gmf.runtime.diagram.ui.l10n.SharedImages;
import org.eclipse.swt.graphics.Image;

public class ConnectionHandle
extends AbstractHandle {
    private static final ImageFigure ERROR_IMAGE = new ImageFigure(SharedImages.get("icons/error.gif"));
    private HandleDirection handleDirection;

    static {
        ERROR_IMAGE.setSize(SharedImages.get((String)"icons/error.gif").getBounds().width, SharedImages.get((String)"icons/error.gif").getBounds().height);
    }

    public ConnectionHandle(IGraphicalEditPart ownerEditPart, HandleDirection relationshipDirection, String tooltip) {
        this.setOwner(ownerEditPart);
        this.setRelationshipDirection(relationshipDirection);
        this.setToolTip((IFigure)new Label(tooltip));
        this.setLayoutManager((LayoutManager)new StackLayout());
    }

    protected DragTracker createDragTracker() {
        return new ConnectionHandleTool(this);
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        if (this.containsPoint(x, y)) {
            return this;
        }
        return super.findFigureAt(x, y, search);
    }

    public void setLocator(Locator locator) {
        super.setLocator(locator);
    }

    public GraphicalEditPart getOwner() {
        return super.getOwner();
    }

    protected void setRelationshipDirection(HandleDirection direction) {
        this.handleDirection = direction;
    }

    public boolean isIncoming() {
        return this.handleDirection == HandleDirection.INCOMING;
    }

    public void addErrorIcon() {
        this.add((IFigure)ERROR_IMAGE);
    }

    public void removeErrorIcon() {
        if (this.getChildren().contains(ERROR_IMAGE)) {
            this.remove((IFigure)ERROR_IMAGE);
        }
    }

    public void validate() {
        if (this.isValid()) {
            return;
        }
        this.removeAll();
        int side = ((ConnectionHandleLocator)this.getLocator()).getBorderSide();
        Image image = this.getImage(side);
        ImageFigure imageFigure = new ImageFigure(image);
        imageFigure.setSize(image.getBounds().width, image.getBounds().height);
        this.add((IFigure)imageFigure);
        this.setSize(imageFigure.getSize().getUnioned(ERROR_IMAGE.getSize()));
        super.validate();
    }

    protected Image getImage(int side) {
        if (side == 8) {
            return this.isIncoming() ? DiagramUIPluginImages.get("icons/handle_incoming_west.gif") : DiagramUIPluginImages.get("icons/handle_outgoing_west.gif");
        }
        if (side == 16) {
            return this.isIncoming() ? DiagramUIPluginImages.get("icons/handle_incoming_east.gif") : DiagramUIPluginImages.get("icons/handle_outgoing_east.gif");
        }
        if (side == 4) {
            return this.isIncoming() ? DiagramUIPluginImages.get("icons/handle_incoming_south.gif") : DiagramUIPluginImages.get("icons/handle_outgoing_south.gif");
        }
        return this.isIncoming() ? DiagramUIPluginImages.get("icons/handle_incoming_north.gif") : DiagramUIPluginImages.get("icons/handle_outgoing_north.gif");
    }

    public static final class HandleDirection {
        public static final HandleDirection OUTGOING = new HandleDirection();
        public static final HandleDirection INCOMING = new HandleDirection();

        private HandleDirection() {
        }
    }
}

