/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.GCUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.Draw2dRenderPlugin;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.image.ImageConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.SVGImageConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.AbstractRenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.Draw2dRenderDebugOptions;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.factory.RenderedImageKey;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;

public final class SVGImage
extends AbstractRenderedImage {
    static /* synthetic */ Class class$0;

    public SVGImage(byte[] buff, RenderedImageKey key) {
        super(buff, key);
        if (key.getExtraData() == null) {
            key.setExtraData((Object)this.getDocument());
        }
    }

    protected Image renderImage() {
        try {
            if (GCUtilities.supportsAdvancedGraphics()) {
                SVGImageConverter converter = new SVGImageConverter();
                return converter.renderSVGtoSWTImage(this.getDocument(), this.getRenderInfo());
            }
            SVGImageConverter converter = new SVGImageConverter();
            BufferedImage img = converter.renderSVGToAWTImage(this.getDocument(), this.getRenderInfo());
            return ImageConverter.convert(img);
        }
        catch (Exception exception) {
            try {
                SVGImageConverter converter = new SVGImageConverter();
                BufferedImage img = converter.renderSVGToAWTImage(this.getDocument(), this.getRenderInfo());
                return ImageConverter.convert(img);
            }
            catch (Exception e1) {
                Trace.catching((Plugin)Draw2dRenderPlugin.getInstance(), (String)Draw2dRenderDebugOptions.EXCEPTIONS_THROWING, ((Object)((Object)this)).getClass(), (String)"getSWTImage()", (Throwable)e1);
                return new Image((Device)Display.getDefault(), 8, 8);
            }
        }
    }

    public Document getDocument() {
        Document document = null;
        if (this.getKey().getExtraData() != null) {
            return (Document)this.getKey().getExtraData();
        }
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        ByteArrayInputStream in = new ByteArrayInputStream(this.getBuffer());
        try {
            document = f.createDocument("http://www.w3.org/2000/svg", (InputStream)in);
        }
        catch (IOException e) {
            Log.error((Plugin)Draw2dRenderPlugin.getInstance(), (int)2, (String)e.getMessage());
        }
        return document;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.image.BufferedImage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            BufferedImage buffImg = null;
            try {
                SVGImageConverter converter = new SVGImageConverter();
                buffImg = converter.renderSVGToAWTImage(this.getDocument(), this.getRenderInfo());
            }
            catch (Exception e) {
                Trace.catching((Plugin)Draw2dRenderPlugin.getInstance(), (String)Draw2dRenderDebugOptions.EXCEPTIONS_THROWING, ((Object)((Object)this)).getClass(), (String)"getSWTImage()", (Throwable)e);
                buffImg = new BufferedImage(8, 8, 2);
            }
            return buffImg;
        }
        return super.getAdapter(adapter);
    }

    public BufferedImage getBufferedImage() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.image.BufferedImage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (BufferedImage)this.getAdapter(clazz);
    }
}

