/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.logic;

import java.io.InputStream;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.util.LogicDiagramFileCreator;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.util.LogicEditorUtil;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Circuit;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.LED;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.SemanticPackage;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.util.DiagramFileCreator;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.AbstractPresentationTestFixture;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LogicTestFixture
extends AbstractPresentationTestFixture {
    protected void createProject() throws Exception {
        IWorkspace workspace = null;
        String aProjectName = "logicProj";
        workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsroot = workspace.getRoot();
        IProject project = wsroot.getProject(aProjectName);
        IProjectDescription desc = workspace.newProjectDescription(project.getName());
        IPath locationPath = Platform.getLocation();
        locationPath = null;
        desc.setLocation(locationPath);
        if (!project.exists()) {
            project.create(desc, null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        this.setProject(project);
    }

    protected void createDiagram() throws Exception {
        IFile diagramFile = LogicEditorUtil.createNewDiagramFile((DiagramFileCreator)LogicDiagramFileCreator.getInstance(), (IPath)this.getProject().getFullPath(), (String)"logicTest", (InputStream)LogicEditorUtil.getInitialContents(), (String)"logic", (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IProgressMonitor)new NullProgressMonitor(), null);
        this.setDiagramFile(diagramFile);
        this.openDiagram();
    }

    protected void createShapesAndConnectors() throws Exception {
        IElementType typeCircuit = ElementTypeRegistry.getInstance().getType("logic.circuit");
        CompoundCommand cc = new CompoundCommand();
        CreateViewAndElementRequest shapeRequest = new CreateViewAndElementRequest(typeCircuit, this.getPreferencesHint());
        shapeRequest.setLocation(new Point(200, 200));
        cc.add(this.getDiagramEditPart().getCommand((Request)shapeRequest));
        shapeRequest.setLocation(new Point(500, 500));
        cc.add(this.getDiagramEditPart().getCommand((Request)shapeRequest));
        this.execute((Command)cc);
    }

    public PreferencesHint getPreferencesHint() {
        return PreferencesHint.USE_DEFAULTS;
    }

    protected Collection execute(ICommand cmd) {
        ICommandProxy command = new ICommandProxy(cmd);
        this.execute((Command)command);
        return DiagramCommandStack.getReturnValues((ICommandProxy)command);
    }

    protected void execute(Command cmd) {
        this.getCommandStack().execute(cmd);
    }

    public EObject createElement(IElementType type, EObject parent, EReference ref) {
        CreateElementRequest cer = new CreateElementRequest(this.getEditingDomain(), parent, type, ref);
        ICommand cmd = type.getEditHelper().getEditCommand((IEditCommandRequest)cer);
        LogicTestFixture.print("\tcreating semantic " + type.getDisplayName() + " element... ");
        Collection result = this.execute(cmd);
        LogicTestFixture.assertTrue((String)("Failed to create " + type.getDisplayName() + " element."), (!result.isEmpty() ? 1 : 0) != 0);
        LogicTestFixture.println("OK.");
        return (EObject)result.iterator().next();
    }

    public LED createLED(EObject parent) {
        IElementType typeLED = ElementTypeRegistry.getInstance().getType("logic.led");
        return (LED)this.createElement(typeLED, parent, SemanticPackage.eINSTANCE.getContainerElement_Children());
    }

    public Circuit createCircuit(EObject parent) {
        IElementType typeCircuit = ElementTypeRegistry.getInstance().getType("logic.circuit");
        return (Circuit)this.createElement(typeCircuit, parent, SemanticPackage.eINSTANCE.getContainerElement_Children());
    }
}

