/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.internal.factory;

import org.eclipse.gmf.runtime.draw2d.ui.render.RenderInfo;
import org.eclipse.swt.graphics.RGB;

class RenderInfoImpl
implements RenderInfo {
    private boolean maintainAspectRatio;
    private boolean antialias;
    private int width;
    private int height;
    private RGB fill = null;
    private RGB outline = null;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean shouldMaintainAspectRatio() {
        return this.maintainAspectRatio;
    }

    public boolean shouldAntiAlias() {
        return this.antialias;
    }

    public RGB getBackgroundColor() {
        if (this.fill == null) {
            return null;
        }
        return new RGB(this.fill.red, this.fill.green, this.fill.blue);
    }

    public RGB getForegroundColor() {
        if (this.outline == null) {
            return null;
        }
        return new RGB(this.outline.red, this.outline.green, this.outline.blue);
    }

    public void setValues(int width, int height, boolean maintainAspectRatio, boolean antialias, RGB fill, RGB outline) {
        this.width = width;
        this.height = height;
        this.fill = fill == null ? null : new RGB(fill.red, fill.green, fill.blue);
        this.outline = outline == null ? null : new RGB(outline.red, outline.green, outline.blue);
        this.maintainAspectRatio = maintainAspectRatio;
        this.antialias = antialias;
    }

    public RenderInfoImpl() {
        this.width = 0;
        this.height = 0;
        this.fill = null;
        this.outline = null;
        this.maintainAspectRatio = true;
        this.antialias = true;
    }

    public RenderInfoImpl(RenderInfo info) {
        this.width = info.getWidth();
        this.height = info.getHeight();
        this.fill = info.getBackgroundColor();
        this.outline = info.getForegroundColor();
        this.maintainAspectRatio = info.shouldMaintainAspectRatio();
        this.antialias = info.shouldAntiAlias();
    }

    public int hashCode() {
        int hashCode = new Integer(this.width).hashCode();
        hashCode += new Integer(this.height).hashCode();
        hashCode += Boolean.valueOf(this.maintainAspectRatio).hashCode();
        hashCode += Boolean.valueOf(this.antialias).hashCode();
        if (this.fill != null) {
            hashCode += this.fill.hashCode();
        }
        if (this.outline != null) {
            hashCode += this.outline.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object object) {
        RenderInfoImpl info = null;
        if (object instanceof RenderInfoImpl) {
            info = (RenderInfoImpl)object;
        }
        if (info != null && this.getWidth() == info.getWidth() && this.getHeight() == info.getHeight() && this.shouldMaintainAspectRatio() == info.shouldMaintainAspectRatio() && this.shouldAntiAlias() == info.shouldAntiAlias()) {
            if (this.getBackgroundColor() == null ? info.getBackgroundColor() != null : !this.getBackgroundColor().equals((Object)info.getBackgroundColor())) {
                return false;
            }
            return !(this.getForegroundColor() == null ? info.getForegroundColor() != null : !this.getForegroundColor().equals((Object)info.getForegroundColor()));
        }
        return false;
    }
}

