/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphCreationWizardPage;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphDiagramEditorPlugin;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphDiagramEditorUtil;
import org.eclipse.gmf.graphdef.editor.part.Messages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class GMFGraphCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected GMFGraphCreationWizardPage diagramModelFilePage;
    protected GMFGraphCreationWizardPage domainModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.GMFGraphCreationWizardTitle);
        this.setDefaultPageImageDescriptor(GMFGraphDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewGMFGraphWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.diagramModelFilePage = new GMFGraphCreationWizardPage("DiagramModelFile", this.getSelection(), "gmfgraph_diagram");
        this.diagramModelFilePage.setTitle(Messages.GMFGraphCreationWizard_DiagramModelFilePageTitle);
        this.diagramModelFilePage.setDescription(Messages.GMFGraphCreationWizard_DiagramModelFilePageDescription);
        this.addPage((IWizardPage)this.diagramModelFilePage);
        this.domainModelFilePage = new GMFGraphCreationWizardPage("DomainModelFile", this.getSelection(), "gmfgraph"){

            public void setVisible(boolean visible) {
                if (visible) {
                    String fileName = GMFGraphCreationWizard.this.diagramModelFilePage.getFileName();
                    fileName = fileName.substring(0, fileName.length() - ".gmfgraph_diagram".length());
                    this.setFileName(GMFGraphDiagramEditorUtil.getUniqueFileName(this.getContainerFullPath(), fileName, "gmfgraph"));
                }
                super.setVisible(visible);
            }
        };
        this.domainModelFilePage.setTitle(Messages.GMFGraphCreationWizard_DomainModelFilePageTitle);
        this.domainModelFilePage.setDescription(Messages.GMFGraphCreationWizard_DomainModelFilePageDescription);
        this.addPage((IWizardPage)this.domainModelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                GMFGraphCreationWizard.this.diagram = GMFGraphDiagramEditorUtil.createDiagram(GMFGraphCreationWizard.this.diagramModelFilePage.getURI(), GMFGraphCreationWizard.this.domainModelFilePage.getURI(), monitor);
                if (GMFGraphCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && GMFGraphCreationWizard.this.diagram != null) {
                    try {
                        GMFGraphDiagramEditorUtil.openDiagram(GMFGraphCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)GMFGraphCreationWizard.this.getContainer().getShell(), (String)Messages.GMFGraphCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.GMFGraphCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                GMFGraphDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }
}

