/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import junit.framework.TestCase;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.gmf.graphdef.codegen.FigureGenerator;
import org.eclipse.gmf.graphdef.codegen.MapModeCodeGenStrategy;
import org.eclipse.gmf.tests.setup.figures.FigureGeneratorUtil;

public class MapModeStrategyTest
extends TestCase {
    public MapModeStrategyTest(String name) {
        super(name);
    }

    public void testPreferredSize() {
        this.checkAllStrategies(this.createFigureWithPreferredSize());
    }

    public void testRoundedRectangleCorners() {
        RoundedRectangle rounded = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        rounded.setName("RoundedRectangleWithCorners");
        rounded.setCornerWidth(23);
        rounded.setCornerHeight(14);
        this.checkAllStrategies((RealFigure)rounded);
    }

    private void checkAllStrategies(RealFigure figure) {
        String baseName = figure.getName();
        try {
            figure.setName(String.valueOf(baseName) + "_StaticIdentity");
            FigureGeneratorUtil.generateAndParse(figure, this.createGenerator(MapModeCodeGenStrategy.STATIC, null));
            figure.setName(String.valueOf(baseName) + "_DefaultMapMode");
            FigureGeneratorUtil.generateAndParse(figure, this.createGenerator(MapModeCodeGenStrategy.DYNAMIC, null));
            figure.setName(String.valueOf(baseName) + "_StandaloneMapMode");
            FigureGeneratorUtil.generateAndParse(figure, this.createGenerator(MapModeCodeGenStrategy.DYNAMIC, "org.eclipse.gmf.tests.sample.figures.PluginActivator.getDefault()."));
        }
        finally {
            figure.setName(baseName);
        }
    }

    private RealFigure createFigureWithPreferredSize() {
        Rectangle figure = GMFGraphFactory.eINSTANCE.createRectangle();
        figure.setName("Figure2WithPreferredSize");
        figure.setPreferredSize(FigureGeneratorUtil.createDimension(234, 567));
        return figure;
    }

    private FigureGenerator createGenerator(MapModeCodeGenStrategy strategy, String accessor) {
        return new FigureGenerator(null, "org.some.pkg", strategy, accessor, false);
    }
}

