/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.tests.ConfiguredTestCase;

public class TestAllDerivedFeatures
extends ConfiguredTestCase {
    public TestAllDerivedFeatures(String name) {
        super(name);
    }

    public void testGMFGenModel() {
        this.checkDerivedFeaturesAreSettings((EObject)this.getSetup().getGenModel().getGenDiagram().getEditorGen());
    }

    public void testGMFMapModel() {
        this.checkDerivedFeaturesAreSettings((EObject)this.getSetup().getMapModel().getMapping());
    }

    private void checkDerivedFeaturesAreSettings(EObject model) {
        TreeIterator it = model.eAllContents();
        do {
            for (EStructuralFeature sf : model.eClass().getEAllStructuralFeatures()) {
                if (!sf.isDerived() || !sf.isMany()) continue;
                Object featureValue = model.eGet(sf);
                String featureName = String.valueOf(sf.getEContainingClass().getName()) + "#" + sf.getName();
                TestAllDerivedFeatures.assertTrue((String)("Feature with * multiplicity (" + featureName + ") should return a list"), (boolean)(featureValue instanceof List));
                TestAllDerivedFeatures.assertTrue((String)("Derived, [*] feature (" + featureName + ") should always implement EStructuralFeature.Setting"), (boolean)(featureValue instanceof EStructuralFeature.Setting));
            }
        } while ((model = it.hasNext() ? (EObject)it.next() : null) != null);
    }
}

