/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2m.internal.qvt.oml.Messages;
import org.eclipse.m2m.internal.qvt.oml.common.CommonPlugin;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QvtKeywords;
import org.eclipse.osgi.util.NLS;

public class QvtNamesChecker {
    public static final String QNAME_DELIMITER = ".";
    private static final String ADJACENT_DELIMITERS_ERROR = "..";
    private static final IStatus invalidCUFileNameStatus = CommonPlugin.createStatus((int)4, (String)NLS.bind((String)Messages.QvtNamesChecker_InvalidCUnitName, (Object[])new String[]{"qvto"}), null);

    private QvtNamesChecker() {
    }

    public static boolean isValidCompilationUnitFileName(String fileName) {
        return QvtNamesChecker.validateCompilationUnitFileName(fileName).isOK();
    }

    public static IStatus validateCompilationUnitFileName(String fileName) {
        boolean isBlank;
        IStatus result = Status.OK_STATUS;
        boolean bl = isBlank = fileName == null || fileName.trim().length() == 0;
        if (isBlank || !fileName.endsWith(".qvto") || fileName.startsWith(QNAME_DELIMITER)) {
            return invalidCUFileNameStatus;
        }
        return result;
    }

    public static String getCompilationUnitMainModuleName(String compilationUnitFileName) {
        int lastPos = compilationUnitFileName.lastIndexOf(".qvto");
        if (lastPos > 0) {
            return compilationUnitFileName.substring(0, lastPos);
        }
        return "";
    }

    public static String extractQualifyingIdentifierPart(String qualifiedIdentifier) {
        if (!QvtNamesChecker.validateQualifiedIdentifier(qualifiedIdentifier, "").isOK()) {
            throw new IllegalArgumentException("Invalid qualifiedIdentifier");
        }
        int pos = qualifiedIdentifier.lastIndexOf(QNAME_DELIMITER);
        if (pos >= 0) {
            return qualifiedIdentifier.substring(0, pos);
        }
        return "";
    }

    public static String extractLocalIdentifierPart(String qualifiedIdentifier) {
        if (!QvtNamesChecker.validateQualifiedIdentifier(qualifiedIdentifier, "").isOK()) {
            throw new IllegalArgumentException("Invalid qualifiedIdentifier");
        }
        String[] segments = QvtNamesChecker.getQualifiedNameSegments(qualifiedIdentifier);
        assert (segments.length > 0);
        return segments[segments.length - 1];
    }

    public static IStatus validateQualifiedIdentifier(String qualifiedIdentifier, String identifierKindName) {
        IStatus result = Status.OK_STATUS;
        if (qualifiedIdentifier == null || qualifiedIdentifier.trim().length() == 0) {
            String message = Messages.QvtNamesChecker_blankIdentifierError;
            return CommonPlugin.createStatus((int)4, (String)NLS.bind((String)message, (Object)identifierKindName), null);
        }
        String[] segments = QvtNamesChecker.getQualifiedNameSegments(qualifiedIdentifier);
        if (segments.length == 0 || qualifiedIdentifier.startsWith(QNAME_DELIMITER) || qualifiedIdentifier.endsWith(QNAME_DELIMITER) || qualifiedIdentifier.indexOf(ADJACENT_DELIMITERS_ERROR) >= 0) {
            String message = Messages.QvtNamesChecker_invalidQualifiedIdentifierError;
            return CommonPlugin.createStatus((int)4, (String)NLS.bind((String)message, (Object)qualifiedIdentifier, (Object)identifierKindName), null);
        }
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segmentName = stringArray[n2];
            IStatus segmentStatus = QvtNamesChecker.validateIdentifier(segmentName, Messages.QvtNamesChecker_namespaceIndentifierKindName);
            if (!segmentStatus.isOK()) {
                return segmentStatus;
            }
            ++n2;
        }
        return result;
    }

    public static IStatus validateNamespaceSimpleIdenfier(String name) {
        return QvtNamesChecker.validateIdentifier(name, Messages.QvtNamesChecker_namespaceIndentifierKindName);
    }

    public static IStatus validateNamespaceQualifiedIdentifier(String name) {
        return QvtNamesChecker.validateQualifiedIdentifier(name, Messages.QvtNamesChecker_namespaceIndentifierKindName);
    }

    public static IStatus validateQvtModuleIdentifier(String name) {
        return QvtNamesChecker.validateIdentifier(name, Messages.QvtNamesChecker_moduleIndentifierKindName);
    }

    public static IStatus validateIdentifier(String name, String identifierKindName) {
        if (name == null || name.trim().length() == 0) {
            return CommonPlugin.createStatus((int)4, (String)NLS.bind((String)Messages.QvtNamesChecker_blankIdentifierError, (Object)identifierKindName), null);
        }
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                Object[] args = new String[]{identifierKindName, name, String.valueOf(c)};
                String message = NLS.bind((String)Messages.QvtNamesChecker_illegalCharInIdentifierError, (Object[])args);
                return CommonPlugin.createStatus((int)4, (String)message, null);
            }
            ++i;
        }
        if (QvtKeywords.isKeyword((String)name)) {
            String message = NLS.bind((String)Messages.QvtNamesChecker_reservedQVTWord, (Object)name);
            return CommonPlugin.createStatus((int)4, (String)message, null);
        }
        return Status.OK_STATUS;
    }

    public static String[] getQualifiedNameSegments(String qualifiedName) {
        StringTokenizer tokenizer = new StringTokenizer(qualifiedName, QNAME_DELIMITER);
        int segmentCount = tokenizer.countTokens();
        String[] segments = new String[segmentCount];
        int i = 0;
        while (i < segmentCount) {
            segments[i] = tokenizer.nextToken();
            ++i;
        }
        return segments;
    }
}

