/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine;

import java.util.ArrayList;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.internal.utils.AcceleoDynamicTemplatesEclipseUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class AcceleoEnginePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.acceleo.engine";
    private static final String DYNAMIC_TEMPLATES_ATTRIBUTE_PATH = "path";
    private static final String DYNAMIC_TEMPLATES_EXTENSION_POINT = "org.eclipse.acceleo.engine.dynamic.templates";
    private static final String DYNAMIC_TEMPLATES_TAG_TEMPLATES = "templates";
    private static AcceleoEnginePlugin plugin;
    private final DynamicTemplatesRegistryListener dynamicTemplatesListener = new DynamicTemplatesRegistryListener();

    public AcceleoEnginePlugin() {
        plugin = this;
    }

    public static AcceleoEnginePlugin getDefault() {
        return plugin;
    }

    public static void log(Exception e, boolean blocker) {
        if (e == null) {
            throw new NullPointerException(AcceleoEngineMessages.getString("AcceleoEnginePlugin.LogNullException"));
        }
        if (AcceleoEnginePlugin.getDefault() == null) {
            e.printStackTrace();
        } else if (e instanceof CoreException) {
            AcceleoEnginePlugin.log(((CoreException)e).getStatus());
        } else if (e instanceof NullPointerException) {
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            AcceleoEnginePlugin.log((IStatus)new Status(severity, PLUGIN_ID, severity, AcceleoEngineMessages.getString("AcceleoEnginePlugin.ElementNotFound"), (Throwable)e));
        } else {
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            AcceleoEnginePlugin.log((IStatus)new Status(severity, PLUGIN_ID, severity, AcceleoEngineMessages.getString("AcceleoEnginePlugin.JavaException"), (Throwable)e));
        }
    }

    public static void log(IStatus status) {
        if (status == null) {
            throw new NullPointerException(AcceleoEngineMessages.getString("AcceleoEnginePlugin.LogNullStatus"));
        }
        if (AcceleoEnginePlugin.getDefault() != null) {
            AcceleoEnginePlugin.getDefault().getLog().log(status);
        } else {
            System.err.println(status.getMessage());
            status.getException().printStackTrace();
        }
    }

    public static void log(String message, boolean blocker) {
        if (AcceleoEnginePlugin.getDefault() == null) {
            System.err.println(message);
        } else {
            String errorMessage;
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            if ((errorMessage = message) == null || "".equals(errorMessage)) {
                errorMessage = AcceleoEngineMessages.getString("AcceleoEnginePlugin.UnexpectedException");
            }
            AcceleoEnginePlugin.log((IStatus)new Status(severity, PLUGIN_ID, errorMessage));
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addListener((IRegistryEventListener)this.dynamicTemplatesListener, DYNAMIC_TEMPLATES_EXTENSION_POINT);
        this.parseInitialContributions();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.removeListener((IRegistryEventListener)this.dynamicTemplatesListener);
        AcceleoDynamicTemplatesEclipseUtil.clearRegistry();
    }

    private void parseInitialContributions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(DYNAMIC_TEMPLATES_EXTENSION_POINT).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            ArrayList<String> pathes = new ArrayList<String>(configElements.length);
            IConfigurationElement[] iConfigurationElementArray = configElements;
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement elem = iConfigurationElementArray[n4];
                if (DYNAMIC_TEMPLATES_TAG_TEMPLATES.equals(elem.getName())) {
                    pathes.add(elem.getAttribute(DYNAMIC_TEMPLATES_ATTRIBUTE_PATH));
                }
                ++n4;
            }
            Bundle bundle = Platform.getBundle((String)extension.getContributor().getName());
            if (bundle != null) {
                AcceleoDynamicTemplatesEclipseUtil.addExtendingBundle(bundle, pathes);
            }
            ++n2;
        }
    }

    final class DynamicTemplatesRegistryListener
    implements IRegistryEventListener {
        DynamicTemplatesRegistryListener() {
        }

        public void added(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                ArrayList<String> pathes = new ArrayList<String>(configElements.length);
                IConfigurationElement[] iConfigurationElementArray = configElements;
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement elem = iConfigurationElementArray[n4];
                    if (AcceleoEnginePlugin.DYNAMIC_TEMPLATES_TAG_TEMPLATES.equals(elem.getName())) {
                        pathes.add(elem.getAttribute(AcceleoEnginePlugin.DYNAMIC_TEMPLATES_ATTRIBUTE_PATH));
                    }
                    ++n4;
                }
                Bundle bundle = Platform.getBundle((String)extension.getContributor().getName());
                if (bundle != null) {
                    AcceleoDynamicTemplatesEclipseUtil.addExtendingBundle(bundle, pathes);
                }
                ++n2;
            }
        }

        public void added(IExtensionPoint[] extensionPoints) {
        }

        public void removed(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                Bundle bundle = Platform.getBundle((String)extension.getContributor().getName());
                if (bundle != null) {
                    AcceleoDynamicTemplatesEclipseUtil.removeExtendingBundle(bundle);
                }
                ++n2;
            }
        }

        public void removed(IExtensionPoint[] extensionPoints) {
        }
    }
}

