/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.scoping;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.internal.scoping.Attribution;
import org.eclipse.ocl.pivot.internal.scoping.EnvironmentView;
import org.eclipse.ocl.pivot.internal.scoping.NullAttribution;
import org.eclipse.ocl.pivot.internal.scoping.ScopeView;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.ParserContext;

public class PivotScopeView
implements ScopeView {
    public static final @NonNull ScopeView NULLSCOPEVIEW = new ScopeView(){

        @Override
        public @NonNull Attribution getAttribution() {
            return NullAttribution.INSTANCE;
        }

        @Override
        public @Nullable Element getChild() {
            return null;
        }

        @Override
        public @Nullable EStructuralFeature getContainmentFeature() {
            return null;
        }

        @Override
        public @NonNull ScopeView getParent() {
            return NULLSCOPEVIEW;
        }

        @Override
        public @NonNull ScopeView getRoot() {
            return NULLSCOPEVIEW;
        }

        @Override
        public Element getTarget() {
            return null;
        }

        @Override
        public boolean isQualified() {
            return false;
        }
    };
    private final @Nullable ParserContext parserContext;
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    protected final @NonNull Element target;
    protected final @Nullable Element child;
    protected final boolean isQualified;
    private ScopeView parent = null;
    private Attribution attribution = null;

    protected PivotScopeView(@NonNull ParserContext parserContext, @NonNull Element target, @Nullable Element child, boolean isQualified) {
        this.parserContext = parserContext;
        this.environmentFactory = (EnvironmentFactoryInternal)parserContext.getEnvironmentFactory();
        this.target = target;
        this.child = child;
        this.isQualified = isQualified;
    }

    @Deprecated
    protected PivotScopeView(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Element target, @Nullable Element child, boolean isQualified) {
        this.parserContext = null;
        this.environmentFactory = environmentFactory;
        this.target = target;
        this.child = child;
        this.isQualified = isQualified;
    }

    public @Nullable ScopeView computeLookup(@NonNull EnvironmentView environmentView, @NonNull EObject aTarget) {
        assert (aTarget instanceof Element);
        if (this.attribution == null) {
            this.attribution = environmentView.getAttribution(this.target);
        }
        return this.attribution.computeLookup(aTarget, environmentView, this);
    }

    @Override
    public @NonNull Attribution getAttribution() {
        Attribution attribution2 = this.attribution;
        if (attribution2 == null) {
            this.attribution = attribution2 = this.parserContext != null ? this.parserContext.getAttribution(this.target) : PivotUtilInternal.getAttribution(this.target);
        }
        return attribution2;
    }

    @Override
    public @Nullable Element getChild() {
        return this.child;
    }

    @Override
    public @Nullable EStructuralFeature getContainmentFeature() {
        return this.child != null ? this.child.eContainmentFeature() : null;
    }

    @Override
    public @NonNull ScopeView getParent() {
        ScopeView parent2 = this.parent;
        if (parent2 == null) {
            EObject pParent = this.target.eContainer();
            parent2 = pParent instanceof Element ? (this.parserContext != null ? new PivotScopeView(this.parserContext, (Element)pParent, this.target, this.isQualified) : new PivotScopeView(this.environmentFactory, (Element)pParent, this.target, this.isQualified)) : NULLSCOPEVIEW;
            this.parent = parent2;
        }
        return parent2;
    }

    @Override
    public @NonNull ScopeView getRoot() {
        ScopeView parent = this.getParent();
        if (parent == NULLSCOPEVIEW) {
            return this;
        }
        return parent.getRoot();
    }

    @Override
    public final @NonNull Element getTarget() {
        return this.target;
    }

    @Override
    public boolean isQualified() {
        return this.isQualified;
    }

    public String toString() {
        Element target = this.getTarget();
        StringBuilder s = new StringBuilder();
        s.append("[");
        s.append(target.eClass().getName());
        EStructuralFeature containmentFeature = this.getContainmentFeature();
        if (containmentFeature != null) {
            s.append("::");
            s.append(containmentFeature.getName());
        }
        s.append("] ");
        s.append(String.valueOf(target));
        return s.toString();
    }
}

