/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.generators.intempora.rtmaps;

import org.eclipse.papyrus.robotml.generators.common.mmqueries.ArchitectureQueries;
import org.eclipse.uml2.uml.Class;

public class RTMapsDataTypeQueries {
    public String getNbElementsInVector(String type_name, String ioelt_name, String return_value_name) {
        if (type_name.compareTo("Bool") == 0 || type_name.compareTo("Int8") == 0 || type_name.compareTo("UInt8") == 0 || type_name.compareTo("Int16") == 0 || type_name.compareTo("UInt16") == 0 || type_name.compareTo("Int32") == 0 || type_name.compareTo("Byte") == 0 || type_name.compareTo("Char") == 0 || type_name.compareTo("UInt32") == 0 || type_name.compareTo("Int64") == 0 || type_name.compareTo("UInt64") == 0 || type_name.compareTo("Time") == 0 || type_name.compareTo("Duration") == 0 || type_name.compareTo("Float32") == 0 || type_name.compareTo("Float64") == 0) {
            return "int " + return_value_name + " = " + ioelt_name + "->VectorSize();";
        }
        if (type_name.compareTo("String") == 0) {
            return "[Strings are not supported yet.]";
        }
        return "int " + return_value_name + " = " + ioelt_name + "->VectorSize() / sizeof(" + type_name + ");";
    }

    public String setVectorSizeForVector(String type_name, int nb_elements, String ioelt_name) {
        if (type_name.compareTo("Bool") == 0 || type_name.compareTo("Int8") == 0 || type_name.compareTo("UInt8") == 0 || type_name.compareTo("Int16") == 0 || type_name.compareTo("UInt16") == 0 || type_name.compareTo("Int32") == 0 || type_name.compareTo("Byte") == 0 || type_name.compareTo("Char") == 0 || type_name.compareTo("UInt32") == 0 || type_name.compareTo("Int64") == 0 || type_name.compareTo("UInt64") == 0 || type_name.compareTo("Time") == 0 || type_name.compareTo("Duration") == 0 || type_name.compareTo("Float32") == 0 || type_name.compareTo("Float64") == 0) {
            return String.valueOf(ioelt_name) + "->VectorSize() = " + nb_elements + ";";
        }
        if (type_name.compareTo("String") == 0) {
            return "[Strings are not supported yet.]";
        }
        return String.valueOf(ioelt_name) + "->VectorSize() = " + nb_elements + " * sizeof(" + type_name + ");";
    }

    public String getMAPSIOEltAccessFunction(String type_name, String ioelt_name, String return_var_name) {
        if (type_name.compareTo("Bool") == 0 || type_name.compareTo("Int8") == 0 || type_name.compareTo("UInt8") == 0 || type_name.compareTo("Int16") == 0 || type_name.compareTo("UInt16") == 0 || type_name.compareTo("Int32") == 0) {
            return "MAPSInt32* " + return_var_name + " = &" + ioelt_name + "->Integer32();";
        }
        if (type_name.compareTo("Byte") == 0 || type_name.compareTo("Char") == 0) {
            return "char* " + return_var_name + " = " + ioelt_name + "->Stream8();";
        }
        if (type_name.compareTo("UInt32") == 0 || type_name.compareTo("Int64") == 0 || type_name.compareTo("UInt64") == 0 || type_name.compareTo("Time") == 0 || type_name.compareTo("Duration") == 0) {
            return "MAPSInt64* " + return_var_name + " = &" + ioelt_name + "->Integer64();";
        }
        if (type_name.compareTo("Float32") == 0) {
            return "MAPSFloat32* " + return_var_name + " = &" + ioelt_name + "->Float32();";
        }
        if (type_name.compareTo("Float64") == 0) {
            return "MAPSFloat64* " + return_var_name + " = &" + ioelt_name + "->Float64();";
        }
        if (type_name.compareTo("String") == 0) {
            return "[Strings are not supported yet.]";
        }
        return String.valueOf(type_name) + "* " + return_var_name + " = (" + type_name + "*)" + ioelt_name + "->Data();";
    }

    public String getMAPSIOEltReturnType(String type_name) {
        if (type_name.compareTo("Bool") == 0 || type_name.compareTo("Int8") == 0 || type_name.compareTo("UInt8") == 0 || type_name.compareTo("Int16") == 0 || type_name.compareTo("UInt16") == 0 || type_name.compareTo("Int32") == 0) {
            return "MAPSInt32*";
        }
        if (type_name.compareTo("Byte") == 0 || type_name.compareTo("Char") == 0) {
            return "MAPSUInt8*";
        }
        if (type_name.compareTo("UInt32") == 0 || type_name.compareTo("Int64") == 0 || type_name.compareTo("UInt64") == 0 || type_name.compareTo("Time") == 0 || type_name.compareTo("Duration") == 0) {
            return "MAPSInt64*";
        }
        if (type_name.compareTo("Float32") == 0) {
            return "MAPSFloat32* ";
        }
        if (type_name.compareTo("Float64") == 0) {
            return "MAPSFloat64*";
        }
        if (type_name.compareTo("String") == 0) {
            return "MAPSRobotMLString*";
        }
        return String.valueOf(type_name) + "*";
    }

    public String getRTMapsOutputDefForPrimitiveType(String output_name, String type_name, int multiplicity) {
        String s = "MAPS_OUTPUT(\"" + output_name + "\",";
        if (type_name.compareTo("Bool") == 0 || type_name.compareTo("Int8") == 0 || type_name.compareTo("UInt8") == 0 || type_name.compareTo("Int16") == 0 || type_name.compareTo("UInt16") == 0 || type_name.compareTo("Int32") == 0) {
            s = String.valueOf(s) + "MAPS::Integer32";
        } else if (type_name.compareTo("Byte") == 0 || type_name.compareTo("Char") == 0) {
            s = String.valueOf(s) + "MAPS::Stream8";
        } else if (type_name.compareTo("UInt32") == 0 || type_name.compareTo("Int64") == 0 || type_name.compareTo("UInt64") == 0 || type_name.compareTo("Time") == 0 || type_name.compareTo("Duration") == 0) {
            s = String.valueOf(s) + "MAPS::Integer64";
        } else if (type_name.compareTo("Float32") == 0) {
            s = String.valueOf(s) + "MAPS::Float32";
        } else if (type_name.compareTo("Float64") == 0) {
            s = String.valueOf(s) + "MAPS::Float64";
        } else if (type_name.compareTo("String") == 0) {
            return "MAPS_OUTPUT_USER_STRUCTURE(" + output_name + ",MAPSRobotMLString)";
        }
        s = String.valueOf(s) + ",NULL,NULL,";
        s = multiplicity <= 0 ? String.valueOf(s) + "DEFAULT_MAX_OUTPUT_VECTOR_SIZE" : String.valueOf(s) + multiplicity;
        s = String.valueOf(s) + ")";
        return s;
    }

    public String getRTMapsInputDefForPrimitiveType(String input_name, String type_name) {
        String s = "MAPS_INPUT(\"" + input_name + "\",";
        if (type_name.compareTo("Bool") == 0 || type_name.compareTo("Int8") == 0 || type_name.compareTo("UInt8") == 0 || type_name.compareTo("Int16") == 0 || type_name.compareTo("UInt16") == 0 || type_name.compareTo("Int32") == 0) {
            s = String.valueOf(s) + "MAPS::FilterInteger32";
        } else if (type_name.compareTo("Byte") == 0 || type_name.compareTo("Char") == 0) {
            s = String.valueOf(s) + "MAPS::FilterStream8";
        } else if (type_name.compareTo("UInt32") == 0 || type_name.compareTo("Int64") == 0 || type_name.compareTo("UInt64") == 0 || type_name.compareTo("Time") == 0 || type_name.compareTo("Duration") == 0) {
            s = String.valueOf(s) + "MAPS::FilterInteger64";
        } else if (type_name.compareTo("Float32") == 0) {
            s = String.valueOf(s) + "MAPS::FilterFloat32";
        } else if (type_name.compareTo("Float64") == 0) {
            s = String.valueOf(s) + "MAPS::FilterFloat64";
        } else if (type_name.compareTo("String") == 0) {
            s = String.valueOf(s) + "MAPSFilterRobotMLString";
        }
        s = String.valueOf(s) + ",MAPS::FifoReader)";
        return s;
    }

    public String getPckOutputDir(String dummy) {
        String os = System.getProperty("os.name");
        if (os.toLowerCase().startsWith("linux")) {
            return "packages/linux_x86/";
        }
        return "packages/";
    }

    public boolean hasRTMapsNativeImplementation(Class c) {
        return ArchitectureQueries.hasNativeImplementation((Class)c) != false && this.getRTMapsNativeLibraryPathFromGenericAttribute(c) != null && this.getRTMapsNativeComponentNameFromGenericAttribute(c) != null;
    }

    public String getRTMapsNativeLibraryPathFromGenericAttribute(Class c) {
        if (ArchitectureQueries.hasNativeImplementation((Class)c).booleanValue()) {
            String native_libs = ArchitectureQueries.getNativeLibraryPathForComponent((Class)c);
            if (native_libs == null) {
                return null;
            }
            return this.getRTMapsSpecificValueFromStringAttribute(native_libs);
        }
        return null;
    }

    public String getRTMapsNativeComponentNameFromGenericAttribute(Class c) {
        if (ArchitectureQueries.hasNativeImplementation((Class)c).booleanValue()) {
            String native_comps = ArchitectureQueries.getNativeComponentNameForComponent((Class)c);
            if (native_comps == null) {
                return null;
            }
            return this.getRTMapsSpecificValueFromStringAttribute(native_comps);
        }
        return null;
    }

    public String getRTMapsSpecificValueFromStringAttribute(String attribute) {
        String[] sections = attribute.split(";");
        int i = 0;
        while (i < sections.length) {
            String[] key_value = sections[i].split("=");
            if (key_value[0].equalsIgnoreCase("rtmaps")) {
                return key_value[1];
            }
            ++i;
        }
        return null;
    }
}

