/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.RobotML;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MobileRobotKind implements Enumerator
{
    AIR_VEHICLE(0, "AirVehicle", "AirVehicle"),
    HYBRID_VEHICLE(1, "HybridVehicle", "HybridVehicle"),
    SURFACE_VEHICLE(2, "SurfaceVehicle", "SurfaceVehicle"),
    UNDERWATER_VEHICLE(3, "UnderwaterVehicle", "UnderwaterVehicle"),
    CAR_LIKE_VEHICLE(4, "CarLikeVehicle", "CarLikeVehicle"),
    DIFFERENTIAL_VEHICLE(5, "DifferentialVehicle", "DifferentialVehicle"),
    LEGGED_VEHICLE(6, "LeggedVehicle", "LeggedVehicle");

    public static final int AIR_VEHICLE_VALUE = 0;
    public static final int HYBRID_VEHICLE_VALUE = 1;
    public static final int SURFACE_VEHICLE_VALUE = 2;
    public static final int UNDERWATER_VEHICLE_VALUE = 3;
    public static final int CAR_LIKE_VEHICLE_VALUE = 4;
    public static final int DIFFERENTIAL_VEHICLE_VALUE = 5;
    public static final int LEGGED_VEHICLE_VALUE = 6;
    private static final MobileRobotKind[] VALUES_ARRAY;
    public static final List<MobileRobotKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MobileRobotKind[]{AIR_VEHICLE, HYBRID_VEHICLE, SURFACE_VEHICLE, UNDERWATER_VEHICLE, CAR_LIKE_VEHICLE, DIFFERENTIAL_VEHICLE, LEGGED_VEHICLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MobileRobotKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MobileRobotKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MobileRobotKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MobileRobotKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MobileRobotKind get(int value) {
        switch (value) {
            case 0: {
                return AIR_VEHICLE;
            }
            case 1: {
                return HYBRID_VEHICLE;
            }
            case 2: {
                return SURFACE_VEHICLE;
            }
            case 3: {
                return UNDERWATER_VEHICLE;
            }
            case 4: {
                return CAR_LIKE_VEHICLE;
            }
            case 5: {
                return DIFFERENTIAL_VEHICLE;
            }
            case 6: {
                return LEGGED_VEHICLE;
            }
        }
        return null;
    }

    private MobileRobotKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

